/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reflection;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackTraceAnalyser {
    private final StackTraceElement stackTraceElement;
    private final Logger logger = LoggerFactory.getLogger(StackTraceAnalyser.class);
    private static final List<String> HIDDEN_PACKAGES = Lists.newArrayList((Object[])new String[]{"sun.", "java", "org.gradle"});

    private StackTraceAnalyser(StackTraceElement stackTraceElement) {
        this.stackTraceElement = stackTraceElement;
    }

    public static StackTraceAnalyser forStackTraceElement(StackTraceElement stackTraceElement) {
        return new StackTraceAnalyser(stackTraceElement);
    }

    public Method getMethod() {
        try {
            Class<?> callingClass;
            Method matchingMethod;
            if (this.allowedClassName(this.stackTraceElement.getClassName()) && !this.lambda(this.stackTraceElement.getClassName()) && (matchingMethod = StackTraceAnalyser.extractMethod(this.stackTraceElement, callingClass = Class.forName(this.stackTraceElement.getClassName()))) != null) {
                return matchingMethod;
            }
        }
        catch (ClassNotFoundException classNotFoundIgnored) {
            this.logger.debug("Couldn't find class during Stack analysis: " + classNotFoundIgnored.getLocalizedMessage());
        }
        catch (NoClassDefFoundError noClassDefFoundErrorIgnored) {
            this.logger.debug("Couldn't find class definition during Stack analysis: " + noClassDefFoundErrorIgnored.getLocalizedMessage());
        }
        return null;
    }

    public Method getUnfilteredMethod() {
        try {
            Class<?> callingClass = Class.forName(this.stackTraceElement.getClassName());
            Method matchingMethod = StackTraceAnalyser.extractMethod(this.stackTraceElement, callingClass);
            if (matchingMethod != null) {
                return matchingMethod;
            }
        }
        catch (ClassNotFoundException classNotFoundIgnored) {
            this.logger.debug("Couldn't find class during Stack analysis: " + classNotFoundIgnored.getLocalizedMessage());
        }
        catch (NoClassDefFoundError noClassDefFoundErrorIgnored) {
            this.logger.debug("Couldn't find class definition during Stack analysis: " + noClassDefFoundErrorIgnored.getLocalizedMessage());
        }
        return null;
    }

    private boolean lambda(String className) {
        return className.contains("$$Lambda$");
    }

    public static Method extractMethod(StackTraceElement stackTraceElement, Class callingClass) {
        Class targetClass = StackTraceAnalyser.isInstrumentedMethod(stackTraceElement) ? callingClass.getSuperclass() : callingClass;
        try {
            return targetClass.getMethod(stackTraceElement.getMethodName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static boolean isInstrumentedMethod(StackTraceElement stackTraceElement) {
        return StringUtils.isNotEmpty((CharSequence)stackTraceElement.getFileName()) && stackTraceElement.getFileName().equals("<generated>");
    }

    private boolean allowedClassName(String className) {
        if (className.contains("$")) {
            return false;
        }
        return !this.inHiddenPackage(className);
    }

    private boolean inHiddenPackage(String className) {
        for (String hiddenPackage : HIDDEN_PACKAGES) {
            if (!className.startsWith(hiddenPackage)) continue;
            return true;
        }
        return false;
    }

    public static List<Method> inscopeMethodsIn(StackTraceElement[] stackTrace) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (StackTraceElement stackTraceElement : stackTrace) {
            Method method = StackTraceAnalyser.forStackTraceElement(stackTraceElement).getMethod();
            if (method == null) continue;
            methods.add(method);
        }
        return methods;
    }
}

