/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.BaseReportingTask;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportProperties;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.util.EnvironmentVariables;

public class ResultReportingTask
extends BaseReportingTask
implements ReportingTask {
    private static final String TEST_OUTCOME_TEMPLATE_PATH = "freemarker/home.ftl";
    final FreemarkerContext freemarker;
    final EnvironmentVariables environmentVariables;
    final File outputDirectory;
    final TestOutcomes testOutcomes;
    final ReportNameProvider reportNameProvider;
    final TestTag tag;
    final String testResult;
    final String reportName;

    public ResultReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, TestOutcomes testOutcomes, ReportNameProvider reportNameProvider, TestTag tag, String testResult) {
        super(freemarker, environmentVariables, outputDirectory);
        this.freemarker = freemarker;
        this.environmentVariables = environmentVariables;
        this.outputDirectory = outputDirectory;
        this.testOutcomes = testOutcomes;
        this.reportNameProvider = reportNameProvider;
        this.tag = tag;
        this.testResult = testResult;
        this.reportName = reportNameProvider.withPrefix(tag).forTestResult(testResult);
    }

    @Override
    public void generateReports() throws IOException {
        Map<String, Object> context = this.freemarker.getBuildContext(this.testOutcomes, this.reportNameProvider, true);
        context.put("report", ReportProperties.forTestResultsReport());
        context.put("currentTagType", this.tag.getType());
        context.put("currentTag", this.tag);
        String csvReport = this.reportNameProvider.forCSVFiles().forTestResult(this.testResult);
        context.put("csvReport", csvReport);
        this.generateReportPage(context, TEST_OUTCOME_TEMPLATE_PATH, this.reportName);
        this.generateCSVReportFor(this.testOutcomes, csvReport);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultReportingTask that = (ResultReportingTask)o;
        return Objects.equal((Object)this.reportName, (Object)that.reportName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.reportName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResultReportingTask{");
        sb.append("reportName='").append(this.reportName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

