/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.junit;

import io.vavr.API;
import io.vavr.collection.List;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.io.SafelyMoveFiles;
import net.thucydides.core.reports.junit.JUnitXMLConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitXMLOutcomeReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JUnitXMLOutcomeReporter.class);
    private final File outputDirectory;
    private final JUnitXMLConverter junitXMLConverter;
    public static final String FILE_PREFIX = "SERENITY-JUNIT-";

    public JUnitXMLOutcomeReporter(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        this.junitXMLConverter = new JUnitXMLConverter();
    }

    public void generateReportsFor(TestOutcomes testOutcomes) throws IOException {
        LOGGER.debug("GENERATING JUNIT REPORTS");
        Map<String, List<TestOutcome>> testOutcomesGroupedByTestCase = this.groupByTestCase(testOutcomes);
        for (String testCase : testOutcomesGroupedByTestCase.keySet()) {
            List<TestOutcome> testCaseOutcomes = testOutcomesGroupedByTestCase.get(testCase);
            String reportFilename = this.reportFilenameFor((TestOutcome)testCaseOutcomes.get(0));
            String unique = UUID.randomUUID().toString();
            File temporary = new File(this.getOutputDirectory(), reportFilename.concat(unique));
            File report = new File(this.getOutputDirectory(), reportFilename);
            report.createNewFile();
            LOGGER.debug("GENERATING JUNIT REPORT {} using temporary file {}", (Object)reportFilename, (Object)temporary);
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(temporary));){
                this.junitXMLConverter.write(testCase, testCaseOutcomes.asJava(), outputStream);
                ((OutputStream)outputStream).flush();
            }
            catch (ParserConfigurationException | TransformerException e) {
                throw new IOException(e);
            }
            SafelyMoveFiles.withMaxRetriesOf(3).from(temporary.toPath()).to(report.toPath());
        }
    }

    private String reportFilenameFor(TestOutcome testOutcome) {
        ReportNamer reportNamer = ReportNamer.forReportType(ReportType.XML);
        return FILE_PREFIX + reportNamer.getNormalizedTestNameFor(testOutcome);
    }

    private Map<String, List<TestOutcome>> groupByTestCase(TestOutcomes testOutcomes) {
        HashMap<String, List<TestOutcome>> groupedTestOutcomes = new HashMap<String, List<TestOutcome>>();
        for (TestOutcome testOutcome : testOutcomes.getOutcomes()) {
            String testCaseName = StringUtils.isNotEmpty((CharSequence)testOutcome.getTestCaseName()) ? testOutcome.getTestCaseName() : testOutcome.getStoryTitle();
            List<TestOutcome> currentOutcomes = groupedTestOutcomes.getOrDefault(testCaseName, (List<TestOutcome>)API.List());
            groupedTestOutcomes.put(testCaseName, (List<TestOutcome>)currentOutcomes.append((Object)testOutcome));
        }
        return groupedTestOutcomes;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }
}

