/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.junit;

import io.vavr.API;
import io.vavr.collection.List;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.junit.JUnitXMLConverter;
import net.thucydides.core.steps.StepEventBus;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitXMLOutcomeReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JUnitXMLOutcomeReporter.class);
    private final File outputDirectory;
    private final JUnitXMLConverter junitXMLConverter;
    public static final String FILE_PREFIX = "SERENITY-JUNIT-";

    public JUnitXMLOutcomeReporter(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        this.junitXMLConverter = new JUnitXMLConverter();
    }

    public void generateReportsFor(TestOutcomes testOutcomes) {
        LOGGER.debug("GENERATING JUNIT REPORTS");
        ((Stream)this.groupByTestCase(testOutcomes).entrySet().stream().parallel()).forEach(entry -> {
            String testCase = (String)entry.getKey();
            List testCaseOutcomes = (List)entry.getValue();
            String reportFilename = this.reportFilenameFor((TestOutcome)testCaseOutcomes.get(0));
            File report = new File(this.getOutputDirectory(), reportFilename);
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(report));){
                this.junitXMLConverter.write(testCase, testCaseOutcomes.asJava(), outputStream);
                ((OutputStream)outputStream).flush();
            }
            catch (IOException | ParserConfigurationException | TransformerException e) {
                LOGGER.warn("Failed to generate JUnit XML report", (Throwable)e);
            }
        });
        StepEventBus.getEventBus().suspendTest(TestResult.SUCCESS);
    }

    private String reportFilenameFor(TestOutcome testOutcome) {
        ReportNamer reportNamer = ReportNamer.forReportType(ReportType.XML);
        return FILE_PREFIX + reportNamer.getNormalizedTestNameFor(testOutcome);
    }

    private Map<String, List<TestOutcome>> groupByTestCase(TestOutcomes testOutcomes) {
        HashMap<String, List<TestOutcome>> groupedTestOutcomes = new HashMap<String, List<TestOutcome>>();
        for (TestOutcome testOutcome : testOutcomes.getOutcomes()) {
            String testCaseName = StringUtils.isNotEmpty((CharSequence)testOutcome.getTestCaseName()) ? testOutcome.getTestCaseName() : testOutcome.getStoryTitle();
            List<TestOutcome> currentOutcomes = groupedTestOutcomes.getOrDefault(testCaseName, (List<TestOutcome>)API.List());
            groupedTestOutcomes.put(testCaseName, (List<TestOutcome>)currentOutcomes.append((Object)testOutcome));
        }
        return groupedTestOutcomes;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }
}

