/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import java.util.List;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.RequirementsOutcomeFactory;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemRequirmentsOutcomeFactory
implements RequirementsOutcomeFactory {
    private final IssueTracking issueTracking;
    private final EnvironmentVariables environmentVariables;
    private final FileSystemRequirementsTagProvider tagProvider;
    private final ReportNameProvider reportNameProvider;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemRequirmentsOutcomeFactory.class);

    public FileSystemRequirmentsOutcomeFactory(EnvironmentVariables environmentVariables, IssueTracking issueTracking, ReportNameProvider reportNameProvider, String rootDirectoryPath) {
        this.issueTracking = issueTracking;
        this.environmentVariables = environmentVariables;
        this.tagProvider = new FileSystemRequirementsTagProvider(environmentVariables, rootDirectoryPath);
        this.reportNameProvider = reportNameProvider;
    }

    @Override
    public RequirementsOutcomes buildRequirementsOutcomesFrom(TestOutcomes testOutcomes) {
        List<Requirement> allRequirements = this.tagProvider.getRequirements();
        LOGGER.debug("Loaded requirements from file system = " + allRequirements);
        return new RequirementsOutcomes(allRequirements, testOutcomes, this.issueTracking, this.environmentVariables, NewList.of(this.tagProvider), this.reportNameProvider);
    }

    @Override
    public RequirementsOutcomes buildRequirementsOutcomesFrom(Requirement parentRequirement, TestOutcomes testOutcomes) {
        List<Requirement> childRequirements = parentRequirement.getChildren();
        return new RequirementsOutcomes(parentRequirement, childRequirements, testOutcomes, this.issueTracking, this.environmentVariables, NewList.of(this.tagProvider), this.reportNameProvider);
    }
}

