/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.serenitybdd.core.strings.Joiner;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.html.MarkdownRendering;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequirementsOverview {
    private final EnvironmentVariables environmentVariables;
    private final Formatter formatter;
    private static final String OVERVIEW = "overview.md";
    private static final String NARRATIVE_TXT = "narrative.txt";
    private static final String NARRATIVE_MD = "narrative.md";
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementsOverview.class);
    private String relativePath = "";

    public String asText() {
        return this.readOverviewText();
    }

    public String asRenderedHtml() {
        if (MarkdownRendering.configuredIn(this.environmentVariables).renderMarkdownFor(MarkdownRendering.RenderedElements.overview)) {
            return this.formatter.renderMarkdown(this.readOverviewText());
        }
        return Formatter.addLineBreaks(this.readOverviewText());
    }

    public static RequirementsOverview withEnvironmentVariables(EnvironmentVariables environmentVariables) {
        return new RequirementsOverview(environmentVariables);
    }

    private List<String> classpathPaths() {
        return Stream.of(OVERVIEW, NARRATIVE_MD, NARRATIVE_TXT).map(this::relativeOverviewFilesOnClasspath).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<String> fileSystemPaths() {
        return Stream.of(OVERVIEW, NARRATIVE_MD, NARRATIVE_TXT).map(this::relativeFileSystemPaths).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<String> relativeOverviewFilesOnClasspath(String overviewFile) {
        return Arrays.asList(this.testRoot() + "/" + this.relativePath() + overviewFile, "/features/" + this.relativePath() + overviewFile, "/stories/" + this.relativePath() + overviewFile);
    }

    private List<String> relativeFileSystemPaths(String overviewFile) {
        return Arrays.asList("src/test/resources/" + this.relativePath() + overviewFile, "src/test/resources/features/" + this.relativePath() + overviewFile, "src/test/resources/stories/" + this.relativePath() + overviewFile);
    }

    private String relativePath() {
        if (this.relativePath.isEmpty()) {
            return this.relativePath;
        }
        return this.relativePath + "/";
    }

    private String testRoot() {
        return ThucydidesSystemProperty.SERENITY_TEST_ROOT.from(this.environmentVariables, "").replaceAll("\\.", "/");
    }

    private RequirementsOverview(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.formatter = new Formatter((IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class), environmentVariables);
    }

    private String readOverviewText() {
        return this.classpathPaths().stream().map(this::readOverviewFromClasspath).filter(overviewText -> !overviewText.isEmpty()).findFirst().orElse(this.readOverviewTextFromFilesystem());
    }

    private String readOverviewTextFromFilesystem() {
        return this.fileSystemPaths().stream().map(this::readOverviewFromFileSystemPath).filter(overviewText -> !overviewText.isEmpty()).findFirst().orElse("");
    }

    private String readOverviewFromClasspath(String path) {
        if (this.getClass().getResource(path) != null) {
            try {
                return Joiner.on(System.lineSeparator()).join(Files.readAllLines(Paths.get(this.getClass().getResource(path).toURI())));
            }
            catch (IOException | URISyntaxException ignoreAndMoveOn) {
                LOGGER.warn("Could not read overview file: " + ignoreAndMoveOn.getMessage());
            }
        }
        return "";
    }

    public RequirementsOverview withRelativePath(String relativePath) {
        this.relativePath = relativePath;
        return this;
    }

    private String readOverviewFromFileSystemPath(String path) {
        if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            try {
                return Joiner.on(System.lineSeparator()).join(Files.readAllLines(Paths.get(path, new String[0])));
            }
            catch (IOException ignoreAndMoveOn) {
                LOGGER.warn("Could not read overview file: " + ignoreAndMoveOn.getMessage());
            }
        }
        return "";
    }
}

