/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import net.thucydides.core.statistics.service.TagProvider;
import net.thucydides.core.statistics.service.TagProviderFilter;
import net.thucydides.core.statistics.service.TagProviderService;
import net.thucydides.core.statistics.service.TagProviderStrategy;

public class ClasspathTagProviderService
implements TagProviderService {
    private TagProviderFilter<TagProvider> filter = new TagProviderFilter();
    private final String ALL_TAG_PROVIDERS = "ALL";
    Map<String, List<TagProvider>> tagProviderCache = new ConcurrentHashMap<String, List<TagProvider>>();

    @Override
    public List<TagProvider> getTagProviders() {
        return this.getTagProviders(null);
    }

    @Override
    public List<TagProvider> getTagProviders(String testSource) {
        if (!this.tagProviderCache.containsKey(this.forTestSource(testSource))) {
            this.tagProviderCache.put(this.forTestSource(testSource), this.tagProvidersFor(testSource));
        }
        return this.tagProviderCache.get(this.forTestSource(testSource));
    }

    private List<TagProvider> tagProvidersFor(String testSource) {
        ArrayList<TagProvider> newTagProviders = new ArrayList<TagProvider>();
        Iterable<? extends TagProvider> tagProviderServiceLoader = this.loadTagProvidersFromPath(testSource);
        for (TagProvider tagProvider : tagProviderServiceLoader) {
            newTagProviders.add(tagProvider);
        }
        return this.filter.removeOverriddenProviders(newTagProviders);
    }

    private String forTestSource(String testSource) {
        return testSource == null ? "ALL" : testSource;
    }

    protected Iterable<? extends TagProvider> loadTagProvidersFromPath(String testSource) {
        ServiceLoader<TagProviderStrategy> tagProviderStrategies = ServiceLoader.load(TagProviderStrategy.class);
        Iterable<? extends TagProvider> tagProvidersWithHighPriority = this.tagProvidersWithHighPriority(tagProviderStrategies, testSource);
        if (tagProvidersWithHighPriority != null) {
            return tagProvidersWithHighPriority;
        }
        if (testSource == null) {
            return this.allKnownTagProviders(tagProviderStrategies);
        }
        return this.tagProvidersThatCanProcess(tagProviderStrategies, testSource);
    }

    private Iterable<? extends TagProvider> tagProvidersWithHighPriority(Iterable<TagProviderStrategy> tagProviderStrategies, String testSource) {
        for (TagProviderStrategy strategy : tagProviderStrategies) {
            if (!this.isHighPriority(strategy) || !strategy.canHandleTestSource(testSource)) continue;
            return strategy.getTagProviders();
        }
        return null;
    }

    private boolean isHighPriority(TagProviderStrategy strategy) {
        try {
            return strategy.hasHighPriority();
        }
        catch (AbstractMethodError usingAnOldAPI) {
            return false;
        }
    }

    private Iterable<? extends TagProvider> tagProvidersThatCanProcess(Iterable<TagProviderStrategy> tagProviderStrategies, String testSource) {
        for (TagProviderStrategy strategy : tagProviderStrategies) {
            if (!strategy.canHandleTestSource(testSource)) continue;
            return strategy.getTagProviders();
        }
        return new ArrayList();
    }

    private Iterable<TagProvider> allKnownTagProviders(Iterable<TagProviderStrategy> tagProviderStrategies) {
        ArrayList<TagProvider> tagProviders = new ArrayList<TagProvider>();
        for (TagProviderStrategy strategy : tagProviderStrategies) {
            strategy.getTagProviders().forEach(tagProviders::add);
        }
        return tagProviders;
    }
}

