/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.reflect.Method;
import net.thucydides.core.steps.StepArgumentWriter;
import net.thucydides.core.util.Inflector;
import org.apache.commons.lang3.StringUtils;

public class StepNamer {
    private final Method method;

    public StepNamer(Method method) {
        this.method = method;
    }

    public static StepNamer forMethod(Method method) {
        return new StepNamer(method);
    }

    public String withArguments(Object[] args) {
        if (this.isScreenplayPerformAs()) {
            return this.screenplayStepWithArgs(args[0]);
        }
        if (args == null || args.length == 0) {
            return this.method.getName();
        }
        return this.testNameWithArguments(this.method, args);
    }

    private String screenplayStepWithArgs(Object actor) {
        String taskName = Inflector.inflection().humanize(Inflector.inflection().underscore(this.method.getDeclaringClass().getSimpleName(), new char[0]), new String[0]);
        return Inflector.inflection().capitalize(actor.toString()) + " " + StringUtils.uncapitalize((String)taskName);
    }

    private boolean isScreenplayPerformAs() {
        return this.method.getName().equals("performAs") && this.method.getParameterCount() == 1;
    }

    private String testNameWithArguments(Method method, Object[] args) {
        StringBuilder testName = new StringBuilder(method.getName());
        testName.append(": ");
        boolean isFirst = true;
        for (Object arg : args) {
            if (!isFirst) {
                testName.append(", ");
            }
            testName.append(StepArgumentWriter.readableFormOf((Object)arg));
            isFirst = false;
        }
        return testName.toString();
    }
}

