/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Splitter;
import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CapabilityValue {
    public static Object asObject(String value) {
        if (StringUtils.isNumeric((CharSequence)value)) {
            return Integer.parseInt(value);
        }
        if (value.toLowerCase().equals("true") || value.toLowerCase().equals("false")) {
            return Boolean.parseBoolean(value);
        }
        if (CapabilityValue.isAList(CapabilityValue.stripQuotesFrom(value))) {
            return CapabilityValue.asList(CapabilityValue.stripQuotesFrom(value));
        }
        if (CapabilityValue.isAMap(CapabilityValue.stripQuotesFrom(value))) {
            return CapabilityValue.asMap(CapabilityValue.stripQuotesFrom(value));
        }
        return value;
    }

    private static String stripQuotesFrom(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    private static boolean isAList(String value) {
        return value.startsWith("[") && value.endsWith("]");
    }

    private static boolean isAMap(String value) {
        return value.startsWith("{") && value.endsWith("}");
    }

    private static List<Object> asList(String value) {
        String listContents = StringUtils.removeEnd((String)StringUtils.removeStart((String)value, (String)"["), (String)"]");
        List items = Splitter.on((String)",").trimResults().splitToList((CharSequence)listContents);
        return items.stream().map(CapabilityValue::asObject).collect(Collectors.toList());
    }

    private static Map<String, Object> asMap(String value) {
        Gson gson = new Gson();
        return (Map)gson.fromJson(value, Map.class);
    }
}

