/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cucumber.api.Result;
import cucumber.api.TestStep;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.api.event.WriteEvent;
import cucumber.api.formatter.Formatter;
import cucumber.runner.PickleTestStep;
import cucumber.runtime.formatter.TaggedScenario;
import cucumber.runtime.formatter.TestSourcesModel;
import gherkin.ast.Background;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.Scenario;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import gherkin.ast.Tag;
import gherkin.pickles.Argument;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleTable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Collectors;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.SerenityListeners;
import net.serenitybdd.core.SerenityReports;
import net.serenitybdd.cucumber.CucumberWithSerenity;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.stacktrace.RootCauseAnalyzer;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import org.apache.commons.lang3.StringUtils;
import org.junit.internal.AssumptionViolatedException;

public class SerenityReporter
implements Formatter {
    private static final String OPEN_PARAM_CHAR = "\uff5f";
    private static final String CLOSE_PARAM_CHAR = "\uff60";
    private static final String SCENARIO_OUTLINE_NOT_KNOWN_YET = "";
    private final Queue<Step> stepQueue;
    private final Queue<TestStep> testStepQueue;
    private Configuration systemConfiguration;
    private final List<BaseStepListener> baseStepListeners;
    private int currentExample = 0;
    private boolean examplesRunning;
    private Map<Integer, Map<String, String>> exampleRows;
    private Map<Integer, List<Tag>> exampleTags;
    private int exampleCount = 0;
    private DataTable table;
    private boolean waitingToProcessBackgroundSteps = false;
    private static final String FEATURES_ROOT_PATH = "features";
    private final TestSourcesModel testSources = new TestSourcesModel();
    private String currentScenarioId;
    private ScenarioDefinition currentScenarioDefinition;
    private String currentScenario;
    private List<Tag> featureTags;
    private boolean addingScenarioOutlineSteps = false;
    private List<Tag> scenarioTags;
    private EventHandler<TestSourceRead> testSourceReadHandler = event -> this.handleTestSourceRead((TestSourceRead)event);
    private EventHandler<TestCaseStarted> caseStartedHandler = event -> this.handleTestCaseStarted((TestCaseStarted)event);
    private EventHandler<TestCaseFinished> caseFinishedHandler = event -> this.handleTestCaseFinished((TestCaseFinished)event);
    private EventHandler<TestStepStarted> stepStartedHandler = event -> this.handleTestStepStarted((TestStepStarted)event);
    private EventHandler<TestStepFinished> stepFinishedHandler = event -> this.handleTestStepFinished((TestStepFinished)event);
    private EventHandler<TestRunStarted> runStartedHandler = event -> this.handleTestRunStarted((TestRunStarted)event);
    private EventHandler<TestRunFinished> runFinishedHandler = event -> this.handleTestRunFinished((TestRunFinished)event);
    private EventHandler<WriteEvent> writeEventHandler = event -> this.handleWrite((WriteEvent)event);
    private ThreadLocal<String> currentFeaturePath = new ThreadLocal();

    public SerenityReporter(Configuration systemConfiguration) {
        this.systemConfiguration = systemConfiguration;
        this.stepQueue = new LinkedList<Step>();
        this.testStepQueue = new LinkedList<TestStep>();
        this.baseStepListeners = Collections.synchronizedList(new ArrayList());
    }

    private void initialiseThucydidesListenersFor(String featurePath) {
        if (StepEventBus.eventBusFor((Object)featurePath).isBaseStepListenerRegistered()) {
            return;
        }
        SerenityListeners listeners = new SerenityListeners(StepEventBus.eventBusFor((Object)featurePath), this.systemConfiguration);
        this.baseStepListeners.add(listeners.getBaseStepListener());
    }

    private void handleTestRunStarted(TestRunStarted event) {
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestRunStarted.class, this.runStartedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.caseFinishedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventHandler);
    }

    private void currentFeaturePathIs(String featurePath) {
        this.currentFeaturePath.set(featurePath);
    }

    private String currentFeaturePath() {
        return this.currentFeaturePath.get();
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.uri, event);
        String featurePath = event.uri;
        Feature feature = this.featureFrom(featurePath);
        this.featureTags = ImmutableList.copyOf((Collection)feature.getTags());
        this.resetEventBusFor(featurePath);
        this.initialiseThucydidesListenersFor(featurePath);
        this.configureDriver(feature, featurePath);
        Story userStory = this.userStoryFrom(feature, this.relativeUriFrom(event.uri));
        StepEventBus.eventBusFor((Object)event.uri).testSuiteStarted(userStory);
    }

    private void resetEventBusFor(String featurePath) {
        StepEventBus.clearEventBusFor((Object)featurePath);
    }

    private String relativeUriFrom(String fullPathUri) {
        String featuresRoot = File.separatorChar + FEATURES_ROOT_PATH + File.separatorChar;
        if (fullPathUri.contains(featuresRoot)) {
            return fullPathUri.substring(fullPathUri.lastIndexOf(featuresRoot) + FEATURES_ROOT_PATH.length() + 2);
        }
        return fullPathUri;
    }

    private Feature featureFrom(String featureFileUri) {
        String defaultFeatureId = new File(featureFileUri).getName().replace(".feature", SCENARIO_OUTLINE_NOT_KNOWN_YET);
        String defaultFeatureName = Inflector.getInstance().humanize(defaultFeatureId, new String[0]);
        Feature feature = this.testSources.getFeature(featureFileUri);
        if (feature.getName().isEmpty()) {
            feature = this.featureWithDefaultName(feature, defaultFeatureName);
        }
        return feature;
    }

    private Story userStoryFrom(Feature feature, String featureFileUri) {
        Story userStory = Story.withIdAndPath((String)TestSourcesModel.convertToId((String)feature.getName()), (String)feature.getName(), (String)featureFileUri).asFeature();
        if (!StringUtils.isEmpty((CharSequence)feature.getDescription())) {
            userStory = userStory.withNarrative(feature.getDescription());
        }
        return userStory;
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        this.currentFeaturePathIs(event.testCase.getUri());
        StepEventBus.setCurrentBusToEventBusFor((Object)event.testCase.getUri());
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeaturePath(), event.testCase.getLine());
        if (astNode != null) {
            boolean newScenario;
            this.currentScenarioDefinition = TestSourcesModel.getScenarioDefinition((TestSourcesModel.AstNode)astNode);
            Feature currentFeature = this.featureFrom(event.testCase.getUri());
            String scenarioId = this.scenarioIdFrom(currentFeature.getName(), TestSourcesModel.convertToId((String)this.currentScenarioDefinition.getName()));
            boolean bl = newScenario = !scenarioId.equals(this.currentScenario);
            if (newScenario) {
                this.configureDriver(currentFeature, this.currentFeaturePath());
                if (this.currentScenarioDefinition instanceof ScenarioOutline) {
                    this.examplesRunning = true;
                    this.addingScenarioOutlineSteps = true;
                    this.examples(currentFeature.getName(), ((ScenarioOutline)this.currentScenarioDefinition).getTags(), this.currentScenarioDefinition.getName(), ((ScenarioOutline)this.currentScenarioDefinition).getExamples());
                }
                this.startOfScenarioLifeCycle(currentFeature, this.currentScenarioDefinition, event.testCase.getLine());
                this.currentScenario = this.scenarioIdFrom(currentFeature.getName(), TestSourcesModel.convertToId((String)this.currentScenarioDefinition.getName()));
            } else if (this.currentScenarioDefinition instanceof ScenarioOutline) {
                this.startExample(event.testCase.getLine());
            }
            Background background = TestSourcesModel.getBackgroundForTestCase((TestSourcesModel.AstNode)astNode);
            if (background != null) {
                this.handleBackground(background);
            }
        }
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        if (this.examplesRunning) {
            this.handleResult(event.result);
        }
        StepEventBus.eventBusFor((Object)event.testCase.getUri()).testFinished();
        this.stepQueue.clear();
        if (this.examplesRunning) {
            this.finishExample();
        }
    }

    private List<String> createCellList(PickleRow row) {
        ArrayList<String> cells = new ArrayList<String>();
        for (PickleCell cell : row.getCells()) {
            cells.add(cell.getValue());
        }
        return cells;
    }

    private void handleTestStepStarted(TestStepStarted event) {
        TestSourcesModel.AstNode astNode;
        if (event.testStep instanceof PickleTestStep && (astNode = this.testSources.getAstNode(this.currentFeaturePath(), event.testStep.getStepLine())) != null) {
            Step step = (Step)astNode.node;
            if (!this.addingScenarioOutlineSteps) {
                this.stepQueue.add(step);
                this.testStepQueue.add(event.testStep);
            }
            Step currentStep = this.stepQueue.peek();
            String stepTitle = this.stepTitleFrom(currentStep, event.testStep);
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).stepStarted(ExecutedStepDescription.withTitle((String)stepTitle));
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).updateCurrentStepTitle(this.normalized(stepTitle));
        }
    }

    private void handleWrite(WriteEvent event) {
        StepEventBus.eventBusFor((Object)this.currentFeaturePath()).stepStarted(ExecutedStepDescription.withTitle((String)event.text));
        StepEventBus.eventBusFor((Object)this.currentFeaturePath()).stepFinished();
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (event.testStep instanceof PickleTestStep) {
            this.handleResult(event.result);
        }
    }

    private void handleTestRunFinished(TestRunFinished event) {
        if (this.examplesRunning) {
            this.finishExample();
        } else {
            this.generateReports();
        }
        this.assureTestSuiteFinished();
    }

    private ReportService getReportService() {
        return SerenityReports.getReportService((Configuration)this.systemConfiguration);
    }

    private Feature featureWithDefaultName(Feature feature, String defaultName) {
        return new Feature(feature.getTags(), feature.getLocation(), feature.getLanguage(), feature.getKeyword(), defaultName, feature.getDescription(), feature.getChildren());
    }

    private void configureDriver(Feature feature, String featurePath) {
        StepEventBus.eventBusFor((Object)featurePath).setUniqueSession(this.systemConfiguration.shouldUseAUniqueBrowser());
        List<String> tags = this.getTagNamesFrom(feature.getTags());
        String requestedDriver = this.getDriverFrom(tags);
        if (StringUtils.isNotEmpty((CharSequence)requestedDriver)) {
            ThucydidesWebDriverSupport.useDefaultDriver((String)requestedDriver);
        }
    }

    private List<String> getTagNamesFrom(List<Tag> tags) {
        ArrayList tagNames = Lists.newArrayList();
        for (Tag tag : tags) {
            tagNames.add(tag.getName());
        }
        return tagNames;
    }

    private String getDriverFrom(List<String> tags) {
        String requestedDriver = null;
        for (String tag : tags) {
            if (!tag.startsWith("@driver:")) continue;
            requestedDriver = tag.substring(8);
        }
        return requestedDriver;
    }

    private void examples(String featureName, List<Tag> scenarioOutlineTags, String id, List<Examples> examplesList) {
        this.addingScenarioOutlineSteps = false;
        this.initializeExamples();
        for (Examples examples : examplesList) {
            if (!this.examplesAreNotExcludedByTags(examples, scenarioOutlineTags)) continue;
            List examplesTableRows = examples.getTableBody();
            List<String> headers = this.getHeadersFrom(examples.getTableHeader());
            List<Map<String, String>> rows = this.getValuesFrom(examplesTableRows, headers);
            for (int i = 0; i < examplesTableRows.size(); ++i) {
                this.addRow(this.exampleRows, headers, (TableRow)examplesTableRows.get(i));
                if (examples.getTags() == null) continue;
                this.exampleTags.put(((TableRow)examplesTableRows.get(i)).getLocation().getLine(), examples.getTags());
            }
            String scenarioId = this.scenarioIdFrom(featureName, id);
            boolean newScenario = !scenarioId.equals(this.currentScenarioId);
            this.table = newScenario ? this.thucydidesTableFrom(SCENARIO_OUTLINE_NOT_KNOWN_YET, headers, rows, this.trim(examples.getName()), this.trim(examples.getDescription())) : this.addTableRowsTo(this.table, headers, rows, this.trim(examples.getName()), this.trim(examples.getDescription()));
            this.exampleCount = this.table.getSize();
            this.currentScenarioId = scenarioId;
        }
    }

    private boolean examplesAreNotExcludedByTags(Examples examples, List<Tag> scenarioOutlineTags) {
        if (this.testRunHasFilterTags()) {
            return this.examplesMatchFilter(examples, scenarioOutlineTags);
        }
        return true;
    }

    private boolean examplesMatchFilter(Examples examples, List<Tag> scenarioOutlineTags) {
        List<Tag> allTags = this.getExampleAllTags(examples, scenarioOutlineTags);
        if (this.examplesHaveFilterTags(allTags)) {
            return allTags.stream().map(Tag::getName).collect(Collectors.toList()).containsAll(this.getCucumberRuntimeTags());
        }
        return false;
    }

    private boolean testRunHasFilterTags() {
        List<String> tagFilters = this.getCucumberRuntimeTags();
        return tagFilters != null && tagFilters.size() > 0;
    }

    private List<String> getCucumberRuntimeTags() {
        if (CucumberWithSerenity.currentRuntimeOptions() == null) {
            return new ArrayList<String>();
        }
        return CucumberWithSerenity.currentRuntimeOptions().getTagFilters();
    }

    private boolean examplesHaveFilterTags(List<Tag> allTags) {
        return allTags.size() > 0;
    }

    private List<Tag> getExampleAllTags(Examples examples, List<Tag> scenarioOutlineTags) {
        List exampleTags = examples.getTags();
        ArrayList<Tag> allTags = new ArrayList<Tag>();
        if (exampleTags != null) {
            allTags.addAll(exampleTags);
        }
        if (scenarioOutlineTags != null) {
            allTags.addAll(scenarioOutlineTags);
        }
        return allTags;
    }

    private List<String> getHeadersFrom(TableRow headerRow) {
        return headerRow.getCells().stream().map(TableCell::getValue).collect(Collectors.toList());
    }

    private List<Map<String, String>> getValuesFrom(List<TableRow> examplesTableRows, List<String> headers) {
        ArrayList rows = Lists.newArrayList();
        for (int row = 0; row < examplesTableRows.size(); ++row) {
            LinkedHashMap rowValues = Maps.newLinkedHashMap();
            int column = 0;
            List cells = examplesTableRows.get(row).getCells().stream().map(TableCell::getValue).collect(Collectors.toList());
            for (String cellValue : cells) {
                String columnName = headers.get(column++);
                rowValues.put(columnName, cellValue);
            }
            rows.add(rowValues);
        }
        return rows;
    }

    private void addRow(Map<Integer, Map<String, String>> exampleRows, List<String> headers, TableRow currentTableRow) {
        LinkedHashMap row = new LinkedHashMap();
        for (int j = 0; j < headers.size(); ++j) {
            List cells = currentTableRow.getCells().stream().map(TableCell::getValue).collect(Collectors.toList());
            row.put(headers.get(j), cells.get(j));
        }
        exampleRows.put(currentTableRow.getLocation().getLine(), row);
    }

    private String scenarioIdFrom(String featureId, String scenarioIdOrExampleId) {
        return featureId != null && scenarioIdOrExampleId != null ? String.format("%s;%s", featureId, scenarioIdOrExampleId) : SCENARIO_OUTLINE_NOT_KNOWN_YET;
    }

    private void initializeExamples() {
        this.examplesRunning = true;
        this.currentExample = 0;
        this.exampleRows = Collections.synchronizedMap(new HashMap());
        this.exampleTags = Collections.synchronizedMap(new HashMap());
    }

    private DataTable thucydidesTableFrom(String scenarioOutline, List<String> headers, List<Map<String, String>> rows, String name, String description) {
        return DataTable.withHeaders(headers).andScenarioOutline(scenarioOutline).andMappedRows(rows).andTitle(name).andDescription(description).build();
    }

    private DataTable addTableRowsTo(DataTable table, List<String> headers, List<Map<String, String>> rows, String name, String description) {
        table.startNewDataSet(name, description);
        for (Map<String, String> row : rows) {
            table.appendRow(this.rowValuesFrom(headers, row));
        }
        return table;
    }

    private List<String> rowValuesFrom(List<String> headers, Map<String, String> row) {
        return headers.stream().map(header -> (String)row.get(header)).collect(Collectors.toList());
    }

    private void startOfScenarioLifeCycle(Feature feature, ScenarioDefinition scenario, Integer currentLine) {
        boolean newScenario = !this.scenarioIdFrom(TestSourcesModel.convertToId((String)feature.getName()), TestSourcesModel.convertToId((String)scenario.getName())).equals(this.currentScenario);
        this.currentScenario = this.scenarioIdFrom(TestSourcesModel.convertToId((String)feature.getName()), TestSourcesModel.convertToId((String)scenario.getName()));
        if (this.examplesRunning) {
            if (newScenario) {
                this.startScenario(feature, scenario);
                StepEventBus.eventBusFor((Object)this.currentFeaturePath()).useExamplesFrom(this.table);
            } else {
                StepEventBus.eventBusFor((Object)this.currentFeaturePath()).addNewExamplesFrom(this.table);
            }
            this.startExample(currentLine);
        } else {
            this.startScenario(feature, scenario);
        }
    }

    private void startScenario(Feature currentFeature, ScenarioDefinition scenarioDefinition) {
        StepEventBus.eventBusFor((Object)this.currentFeaturePath()).setTestSource("Cucumber");
        StepEventBus.eventBusFor((Object)this.currentFeaturePath()).testStarted(scenarioDefinition.getName(), this.scenarioIdFrom(TestSourcesModel.convertToId((String)currentFeature.getName()), TestSourcesModel.convertToId((String)scenarioDefinition.getName())));
        StepEventBus.eventBusFor((Object)this.currentFeaturePath()).addDescriptionToCurrentTest(scenarioDefinition.getDescription());
        StepEventBus.eventBusFor((Object)this.currentFeaturePath()).addTagsToCurrentTest(this.convertCucumberTags(currentFeature.getTags()));
        if (this.isScenario(scenarioDefinition)) {
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).addTagsToCurrentTest(this.convertCucumberTags(((Scenario)scenarioDefinition).getTags()));
        } else if (this.isScenarioOutline(scenarioDefinition)) {
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).addTagsToCurrentTest(this.convertCucumberTags(((ScenarioOutline)scenarioDefinition).getTags()));
        }
        this.registerFeatureJiraIssues(currentFeature.getTags());
        List<Tag> tags = this.getTagsOfScenarioDefinition(scenarioDefinition);
        this.registerScenarioJiraIssues(tags);
        this.scenarioTags = this.tagsForScenario(scenarioDefinition);
        this.updateResultsFromTagsIn(this.scenarioTags);
    }

    private List<Tag> tagsForScenario(ScenarioDefinition scenarioDefinition) {
        ArrayList<Tag> scenarioTags = new ArrayList<Tag>(this.featureTags);
        scenarioTags.addAll(this.getTagsOfScenarioDefinition(scenarioDefinition));
        return scenarioTags;
    }

    private void updateResultsFromTagsIn(List<Tag> tags) {
        if (TaggedScenario.isManual(tags)) {
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).testIsManual();
        }
        if (TaggedScenario.isPending(tags)) {
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).testPending();
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).getBaseStepListener().overrideResultTo(TestResult.PENDING);
        }
        if (TaggedScenario.isSkippedOrWIP(tags)) {
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).testSkipped();
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).getBaseStepListener().overrideResultTo(TestResult.SKIPPED);
        }
        if (TaggedScenario.isIgnored(tags)) {
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).testIgnored();
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).getBaseStepListener().overrideResultTo(TestResult.IGNORED);
        }
    }

    private boolean isScenario(ScenarioDefinition scenarioDefinition) {
        return scenarioDefinition instanceof Scenario;
    }

    private boolean isScenarioOutline(ScenarioDefinition scenarioDefinition) {
        return scenarioDefinition instanceof ScenarioOutline;
    }

    private List<Tag> getTagsOfScenarioDefinition(ScenarioDefinition scenarioDefinition) {
        List tags = new ArrayList();
        if (this.isScenario(scenarioDefinition)) {
            tags = ((Scenario)scenarioDefinition).getTags();
        } else if (this.isScenarioOutline(scenarioDefinition)) {
            tags = ((ScenarioOutline)scenarioDefinition).getTags();
        }
        return tags;
    }

    private void registerFeatureJiraIssues(List<Tag> tags) {
        List<String> issues = this.extractJiraIssueTags(tags);
        if (!issues.isEmpty()) {
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).addIssuesToCurrentStory(issues);
        }
    }

    private void registerScenarioJiraIssues(List<Tag> tags) {
        List<String> issues = this.extractJiraIssueTags(tags);
        if (!issues.isEmpty()) {
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).addIssuesToCurrentTest(issues);
        }
    }

    private List<TestTag> convertCucumberTags(List<Tag> cucumberTags) {
        ArrayList tags = Lists.newArrayList();
        for (Tag tag : cucumberTags) {
            tags.add(TestTag.withValue((String)tag.getName().substring(1)));
        }
        return ImmutableList.copyOf((Collection)tags);
    }

    private List<String> extractJiraIssueTags(List<Tag> cucumberTags) {
        ArrayList issues = Lists.newArrayList();
        for (Tag tag : cucumberTags) {
            if (tag.getName().startsWith("@issue:")) {
                String tagIssueValue = tag.getName().substring("@issue:".length());
                issues.add(tagIssueValue);
            }
            if (!tag.getName().startsWith("@issues:")) continue;
            String tagIssuesValues = tag.getName().substring("@issues:".length());
            issues.addAll(Arrays.asList(tagIssuesValues.split(",")));
        }
        return issues;
    }

    private void startExample(Integer lineNumber) {
        Map<String, String> data = this.exampleRows.get(lineNumber);
        StepEventBus.eventBusFor((Object)this.currentFeaturePath()).clearStepFailures();
        StepEventBus.eventBusFor((Object)this.currentFeaturePath()).exampleStarted(data);
        if (this.exampleTags.containsKey(lineNumber)) {
            List<Tag> currentExampleTags = this.exampleTags.get(lineNumber);
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).addTagsToCurrentTest(this.convertCucumberTags(currentExampleTags));
        }
        ++this.currentExample;
    }

    private void finishExample() {
        StepEventBus.eventBusFor((Object)this.currentFeaturePath()).exampleFinished();
        --this.exampleCount;
        if (this.exampleCount == 0) {
            this.examplesRunning = false;
            this.setTableScenarioOutline();
            this.generateReports();
        } else {
            this.examplesRunning = true;
        }
    }

    private void setTableScenarioOutline() {
        List steps = this.currentScenarioDefinition.getSteps();
        StringBuffer scenarioOutlineBuffer = new StringBuffer();
        for (Step step : steps) {
            scenarioOutlineBuffer.append(step.getKeyword()).append(step.getText()).append("\n\r");
        }
        String scenarioOutline = scenarioOutlineBuffer.toString();
        if (this.table != null) {
            this.table.setScenarioOutline(scenarioOutline);
        }
    }

    private void handleBackground(Background background) {
        String backgroundDescription;
        this.waitingToProcessBackgroundSteps = true;
        String backgroundName = background.getName();
        if (backgroundName != null) {
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).setBackgroundTitle(backgroundName);
        }
        if ((backgroundDescription = background.getDescription()) == null) {
            backgroundDescription = SCENARIO_OUTLINE_NOT_KNOWN_YET;
        }
        StepEventBus.eventBusFor((Object)this.currentFeaturePath()).setBackgroundDescription(backgroundDescription);
    }

    private void assureTestSuiteFinished() {
        this.stepQueue.clear();
        this.testStepQueue.clear();
        Optional.ofNullable(this.currentFeaturePath()).ifPresent(featurePath -> {
            StepEventBus.eventBusFor((Object)featurePath).testSuiteFinished();
            StepEventBus.eventBusFor((Object)featurePath).clear();
            StepEventBus.clearEventBusFor((Object)featurePath);
        });
        Serenity.done();
        this.table = null;
        this.currentScenarioId = null;
    }

    private void handleResult(Result result) {
        Step currentStep = this.stepQueue.poll();
        TestStep currentTestStep = this.testStepQueue.poll();
        this.recordStepResult(result, currentStep, currentTestStep);
        if (this.stepQueue.isEmpty()) {
            this.recordFinalResult();
        }
    }

    private void recordStepResult(Result result, Step currentStep, TestStep currentTestStep) {
        if (Result.Type.PASSED.equals((Object)result.getStatus())) {
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).stepFinished();
        } else if (Result.Type.FAILED.equals((Object)result.getStatus())) {
            this.failed(this.stepTitleFrom(currentStep, currentTestStep), result.getError());
        } else if (Result.Type.SKIPPED.equals((Object)result.getStatus())) {
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).stepIgnored();
        } else if (Result.Type.PENDING.equals((Object)result.getStatus())) {
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).stepPending();
        } else if (Result.Type.UNDEFINED.equals((Object)result.getStatus())) {
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).stepPending();
        }
    }

    private void recordFinalResult() {
        if (this.waitingToProcessBackgroundSteps) {
            this.waitingToProcessBackgroundSteps = false;
        } else {
            this.updateResultFromTags(this.scenarioTags);
        }
    }

    private void updateResultFromTags(List<Tag> scenarioTags) {
        if (TaggedScenario.isManual(scenarioTags)) {
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).testIsManual();
        }
        if (TaggedScenario.isPending(scenarioTags)) {
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).testPending();
        }
        if (TaggedScenario.isSkippedOrWIP(scenarioTags)) {
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).testSkipped();
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).getBaseStepListener().overrideResultTo(TestResult.SKIPPED);
        }
        if (TaggedScenario.isIgnored(scenarioTags)) {
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).testIgnored();
            StepEventBus.eventBusFor((Object)this.currentFeaturePath()).getBaseStepListener().overrideResultTo(TestResult.IGNORED);
        }
    }

    private void failed(String stepTitle, Throwable cause) {
        if (!this.errorOrFailureRecordedForStep(stepTitle, cause)) {
            Throwable rootCause;
            if (!StringUtils.isEmpty((CharSequence)stepTitle)) {
                StepEventBus.eventBusFor((Object)this.currentFeaturePath()).updateCurrentStepTitle(stepTitle);
            }
            if (this.isAssumptionFailure(rootCause = new RootCauseAnalyzer(cause).getRootCause().toException())) {
                StepEventBus.eventBusFor((Object)this.currentFeaturePath()).assumptionViolated(rootCause.getMessage());
            } else {
                StepEventBus.eventBusFor((Object)this.currentFeaturePath()).stepFailed(new StepFailure(ExecutedStepDescription.withTitle((String)this.normalized(this.currentStepTitle())), rootCause));
            }
        }
    }

    private String currentStepTitle() {
        return StepEventBus.eventBusFor((Object)this.currentFeaturePath()).getCurrentStep().isPresent() ? ((net.thucydides.core.model.TestStep)StepEventBus.eventBusFor((Object)this.currentFeaturePath()).getCurrentStep().get()).getDescription() : SCENARIO_OUTLINE_NOT_KNOWN_YET;
    }

    private boolean errorOrFailureRecordedForStep(String stepTitle, Throwable cause) {
        if (!this.latestTestOutcome().isPresent()) {
            return false;
        }
        if (!((TestOutcome)this.latestTestOutcome().get()).testStepWithDescription(stepTitle).isPresent()) {
            return false;
        }
        com.google.common.base.Optional matchingTestStep = ((TestOutcome)this.latestTestOutcome().get()).testStepWithDescription(stepTitle);
        if (matchingTestStep.isPresent() && ((net.thucydides.core.model.TestStep)matchingTestStep.get()).getException() != null) {
            return ((net.thucydides.core.model.TestStep)matchingTestStep.get()).getException().getOriginalCause() == cause;
        }
        return false;
    }

    private com.google.common.base.Optional<TestOutcome> latestTestOutcome() {
        List recordedOutcomes = StepEventBus.eventBusFor((Object)this.currentFeaturePath()).getBaseStepListener().getTestOutcomes();
        return recordedOutcomes.isEmpty() ? com.google.common.base.Optional.absent() : com.google.common.base.Optional.of(recordedOutcomes.get(recordedOutcomes.size() - 1));
    }

    private boolean isAssumptionFailure(Throwable rootCause) {
        return AssumptionViolatedException.class.isAssignableFrom(rootCause.getClass());
    }

    private String stepTitleFrom(Step currentStep, TestStep testStep) {
        if (currentStep != null) {
            return currentStep.getKeyword() + testStep.getPickleStep().getText() + this.embeddedTableDataIn(testStep);
        }
        return SCENARIO_OUTLINE_NOT_KNOWN_YET;
    }

    private String embeddedTableDataIn(TestStep currentStep) {
        Argument argument;
        if (!currentStep.getStepArgument().isEmpty() && (argument = (Argument)currentStep.getStepArgument().get(0)) instanceof PickleTable) {
            ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
            for (PickleRow row : ((PickleTable)argument).getRows()) {
                HashMap<String, List<String>> rowMap = new HashMap<String, List<String>>();
                rowMap.put("cells", this.createCellList(row));
                rowList.add(rowMap);
            }
            return this.convertToTextTable(rowList);
        }
        return SCENARIO_OUTLINE_NOT_KNOWN_YET;
    }

    private String convertToTextTable(List<Map<String, Object>> rows) {
        StringBuilder textTable = new StringBuilder();
        textTable.append(System.lineSeparator());
        for (Map<String, Object> row : rows) {
            textTable.append("|");
            for (String cell : (List)row.get("cells")) {
                textTable.append(" ");
                textTable.append(cell);
                textTable.append(" |");
            }
            if (row == rows.get(rows.size() - 1)) continue;
            textTable.append(System.lineSeparator());
        }
        return textTable.toString();
    }

    private void generateReports() {
        this.getReportService().generateReportsFor(this.getAllTestOutcomes());
    }

    public List<TestOutcome> getAllTestOutcomes() {
        return this.baseStepListeners.stream().map(BaseStepListener::getTestOutcomes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private String normalized(String value) {
        return value.replaceAll(OPEN_PARAM_CHAR, "{").replaceAll(CLOSE_PARAM_CHAR, "}");
    }

    private String trim(String stringToBeTrimmed) {
        return stringToBeTrimmed == null ? stringToBeTrimmed : stringToBeTrimmed.trim();
    }
}

