/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.service;

import java.util.Arrays;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.core.statistics.service.ContextTagProvider;
import net.thucydides.core.statistics.service.InjectedTagProvider;
import net.thucydides.core.statistics.service.TagProvider;
import net.thucydides.core.statistics.service.TagProviderStrategy;
import net.thucydides.core.util.EnvironmentVariables;

public class CucumberTagProviderStrategy
implements TagProviderStrategy {
    private final EnvironmentVariables environmentVariables;

    public CucumberTagProviderStrategy(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public CucumberTagProviderStrategy() {
        this((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public boolean canHandleTestSource(String testType) {
        return "Cucumber".equalsIgnoreCase(testType);
    }

    public Iterable<? extends TagProvider> getTagProviders() {
        String rootDirectory = ThucydidesSystemProperty.THUCYDIDES_REQUIREMENTS_DIR.from(this.environmentVariables, "features");
        return Arrays.asList(new FileSystemRequirementsTagProvider(this.environmentVariables, rootDirectory), new InjectedTagProvider(this.environmentVariables), new ContextTagProvider());
    }

    public boolean hasHighPriority() {
        return false;
    }
}

