/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira.requirements;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.List;
import net.serenitybdd.plugins.jira.client.JIRAAuthenticationError;
import net.serenitybdd.plugins.jira.client.JIRAConfigurationError;
import net.serenitybdd.plugins.jira.client.JerseyJiraClient;
import net.serenitybdd.plugins.jira.domain.IssueSummary;
import net.serenitybdd.plugins.jira.model.JQLException;
import net.serenitybdd.plugins.jira.requirements.JIRARequirementsProvider;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableJiraClient
extends JerseyJiraClient {
    private static final String FAIL_ON_JIRA_ERROR = "thucydides.fail.on.jira.error";
    private final EnvironmentVariables environmentVariables;
    private final Logger logger = LoggerFactory.getLogger(JIRARequirementsProvider.class);

    public ConfigurableJiraClient(String url, String username, String password, String project) {
        super(url, username, password, project, ConfigurableJiraClient.customFields());
        this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get();
    }

    private static List<String> customFields() {
        EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get();
        return Lists.newArrayList();
    }

    public List<IssueSummary> findByJQL(String query) {
        try {
            return super.findByJQL(query);
        }
        catch (JIRAAuthenticationError authenticationError) {
            if (this.failOnJiraErrors()) {
                throw authenticationError;
            }
            this.logger.error("Could not connect to JIRA", (Throwable)authenticationError);
        }
        catch (JIRAConfigurationError configurationError) {
            if (this.failOnJiraErrors()) {
                throw configurationError;
            }
            this.logger.error("Could not connect to JIRA", (Throwable)configurationError);
        }
        return Lists.newArrayList();
    }

    private boolean failOnJiraErrors() {
        return this.environmentVariables.getPropertyAsBoolean(FAIL_ON_JIRA_ERROR, false);
    }

    public Optional<IssueSummary> findByKey(String key) throws JQLException {
        try {
            return super.findByKey(key);
        }
        catch (JIRAAuthenticationError jIRAAuthenticationError) {
        }
        catch (JIRAConfigurationError jIRAConfigurationError) {
            // empty catch block
        }
        return Optional.absent();
    }
}

