/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira.requirements;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.serenitybdd.plugins.jira.domain.CustomFieldCast;
import net.serenitybdd.plugins.jira.domain.IssueSummary;
import net.serenitybdd.plugins.jira.requirements.JIRARequirementsConfiguration;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class RequirementsAdaptor {
    private final EnvironmentVariables environmentVariables;

    public RequirementsAdaptor(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public Requirement requirementFrom(IssueSummary issue) {
        Requirement baseRequirement = Requirement.named((String)issue.getSummary()).withOptionalCardNumber(issue.getKey()).withType(issue.getType()).withNarrative(this.narativeTextFrom(issue)).withReleaseVersions(issue.getFixVersions());
        for (String fieldName : this.definedCustomFields()) {
            if (!issue.customField(fieldName).isPresent()) continue;
            String value = ((CustomFieldCast)issue.customField(fieldName).get()).asString();
            String renderedValue = (String)issue.getRendered().customField(fieldName).get();
            baseRequirement = baseRequirement.withCustomField(fieldName).setTo(value, renderedValue);
        }
        return baseRequirement;
    }

    private String narativeTextFrom(IssueSummary issue) {
        Optional customFieldName = Optional.fromNullable((Object)this.environmentVariables.getProperty(JIRARequirementsConfiguration.JIRA_CUSTOM_NARRATIVE_FIELD.getName()));
        if (customFieldName.isPresent()) {
            return (String)this.customFieldNameFor(issue, (String)customFieldName.get()).or(ObjectUtils.firstNonNull((Object[])new String[]{issue.getRendered().getDescription(), ""}));
        }
        return issue.getRendered().getDescription();
    }

    private List<String> definedCustomFields() {
        ArrayList customFields = Lists.newArrayList();
        int customFieldIndex = 1;
        while (this.addCustomFieldIfDefined(this.environmentVariables, customFields, this.customFieldNumber(customFieldIndex++))) {
        }
        return customFields;
    }

    private Optional<String> customFieldNameFor(IssueSummary issue, String customFieldName) {
        if (issue.customField(customFieldName).isPresent()) {
            return Optional.of((Object)((CustomFieldCast)issue.customField(customFieldName).get()).asString());
        }
        return Optional.absent();
    }

    private boolean addCustomFieldIfDefined(EnvironmentVariables environmentVariables, List<String> customFields, String customField) {
        String customFieldName = environmentVariables.getProperty(customField);
        if (StringUtils.isNotEmpty((CharSequence)customFieldName)) {
            customFields.add(customFieldName);
            return true;
        }
        return false;
    }

    private String customFieldNumber(int customFieldIndex) {
        return JIRARequirementsConfiguration.JIRA_CUSTOM_FIELD.getName() + "." + customFieldIndex;
    }
}

