/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.runners;

import java.lang.reflect.Method;
import net.serenitybdd.junit.runners.RunNotifierDecorator;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryFilteringRunNotifier
extends RunNotifierDecorator {
    private static final Logger log = LoggerFactory.getLogger(RetryFilteringRunNotifier.class);
    private RunNotifier target;
    private RunNotifier retryAwareRunNotifier;
    private boolean testFailed = false;
    private Failure lastFailure;
    private boolean testAssumptionFailed = false;
    private Failure lastAssumptionFailure;
    private boolean testStartAlreadyFired = false;
    private Description lastIgnored;
    private Description lastDescription;

    public RetryFilteringRunNotifier(RunNotifier target, RunNotifier retryAwareRunNotifier) {
        this.target = target;
        this.retryAwareRunNotifier = retryAwareRunNotifier;
    }

    @Override
    public void fireTestStarted(Description description) throws StoppedByUserException {
        log.debug("Test started: " + description);
        if (!this.testStartAlreadyFired) {
            super.fireTestStarted(description);
        }
        this.testStartAlreadyFired = true;
        this.retryAwareRunNotifier.fireTestStarted(description);
    }

    @Override
    public void fireTestFailure(Failure failure) {
        if (this.isExpected(failure)) {
            this.fireTestFinished(failure.getDescription());
        } else {
            log.debug("Test failed: " + failure, failure.getException());
            this.testStartAlreadyFired = false;
            this.testFailed = true;
            this.lastFailure = failure;
            this.retryAwareRunNotifier.fireTestFailure(failure);
        }
    }

    private boolean isExpected(Failure failure) {
        if (failure.getDescription().getTestClass() == null || failure.getDescription().getMethodName() == null) {
            return false;
        }
        try {
            Method testMethod = failure.getDescription().getTestClass().getMethod(failure.getDescription().getMethodName(), new Class[0]);
            Test testAnnotation = testMethod.getAnnotation(Test.class);
            if (testAnnotation.expected() != null) {
                return failure.getException().getClass().isAssignableFrom(testAnnotation.expected());
            }
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return false;
    }

    public void flush() {
        log.debug("Flushing notifications");
        if (this.testFailed) {
            super.fireTestFailure(this.lastFailure);
        }
        if (this.testAssumptionFailed) {
            super.fireTestAssumptionFailed(this.lastAssumptionFailure);
        }
        if (this.lastIgnored != null) {
            super.fireTestIgnored(this.lastIgnored);
        }
        if (this.lastDescription != null) {
            super.fireTestFinished(this.lastDescription);
        }
    }

    public void reset() {
        this.testFailed = false;
        this.testAssumptionFailed = false;
        this.lastIgnored = null;
        this.lastDescription = null;
    }

    @Override
    public void fireTestFinished(Description description) {
        this.testStartAlreadyFired = false;
        log.debug("Test finished: " + description);
        this.lastDescription = description;
        this.retryAwareRunNotifier.fireTestFinished(description);
    }

    @Override
    public void fireTestIgnored(Description description) {
        log.debug("Test ignored: " + description);
        this.lastIgnored = description;
        if (!this.testStartAlreadyFired) {
            super.fireTestStarted(description);
        }
        this.testStartAlreadyFired = false;
        this.retryAwareRunNotifier.fireTestIgnored(description);
    }

    @Override
    public void fireTestAssumptionFailed(Failure failure) {
        log.debug("Test assumption failed: " + failure);
        this.lastAssumptionFailure = failure;
        this.testAssumptionFailed = true;
        this.retryAwareRunNotifier.fireTestAssumptionFailed(failure);
    }

    @Override
    public void fireTestRunStarted(Description description) {
        super.fireTestRunStarted(description);
    }

    @Override
    public void fireTestRunFinished(Result result) {
        super.fireTestRunFinished(result);
        this.retryAwareRunNotifier.fireTestRunFinished(result);
    }

    @Override
    protected RunNotifier underlyingNotifier() {
        return this.target;
    }

    public boolean lastTestFailed() {
        return this.lastFailure != null;
    }

    public void clearLastFailure() {
        this.testFailed = false;
        this.lastFailure = null;
        this.testAssumptionFailed = false;
        this.lastAssumptionFailure = null;
    }
}

