/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.listeners;

import java.io.File;
import java.util.List;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.stacktrace.FailureCause;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepListener;
import net.thucydides.junit.listeners.JUnitStepListenerBuilder;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnitStepListener
extends RunListener {
    private BaseStepListener baseStepListener;
    private StepListener[] extraListeners;
    private Class<?> testClass;
    private boolean testStarted = false;

    public static JUnitStepListenerBuilder withOutputDirectory(File outputDirectory) {
        return new JUnitStepListenerBuilder(outputDirectory);
    }

    protected JUnitStepListener(Class<?> testClass, BaseStepListener baseStepListener, StepListener ... listeners) {
        this.baseStepListener = baseStepListener;
        this.extraListeners = listeners;
        this.testClass = testClass;
        this.registerThucydidesListeners();
    }

    public void registerThucydidesListeners() {
        StepEventBus.getEventBus().registerListener((StepListener)this.baseStepListener);
        for (StepListener listener : this.extraListeners) {
            StepEventBus.getEventBus().registerListener(listener);
        }
    }

    public BaseStepListener getBaseStepListener() {
        return this.baseStepListener;
    }

    public void testRunStarted(Description description) throws Exception {
        super.testRunStarted(description);
    }

    public void testRunFinished(Result result) throws Exception {
        StepEventBus.getEventBus().testRunFinished();
        super.testRunFinished(result);
    }

    public void testStarted(Description description) {
        if (this.testingThisTest(description)) {
            this.startTestSuiteForFirstTest(description);
            StepEventBus.getEventBus().clear();
            StepEventBus.getEventBus().testStarted(description.getMethodName(), description.getTestClass());
            this.startTest();
        }
    }

    private void startTestSuiteForFirstTest(Description description) {
        if (!this.getBaseStepListener().testSuiteRunning()) {
            StepEventBus.getEventBus().testSuiteStarted(description.getTestClass());
        }
    }

    public void testFinished(Description description) throws Exception {
        if (this.testingThisTest(description)) {
            this.updateResultsUsingTestAnnotations(description);
            StepEventBus.getEventBus().testFinished();
            this.endTest();
        }
    }

    private void updateResultsUsingTestAnnotations(Description description) {
        Test testAnnotation = (Test)description.getAnnotation(Test.class);
        if (testAnnotation.expected() != null) {
            this.updateResultsForExpectedException(testAnnotation.expected());
        }
    }

    private void updateResultsForExpectedException(Class<? extends Throwable> expected) {
        StepEventBus.getEventBus().exceptionExpected(expected);
    }

    public void testFailure(Failure failure) throws Exception {
        if (this.testingThisTest(failure.getDescription())) {
            this.startTestIfNotYetStarted(failure.getDescription());
            StepEventBus.getEventBus().testFailed(failure.getException());
            this.endTest();
        }
    }

    private void startTestIfNotYetStarted(Description description) {
        if (!this.testStarted) {
            this.testStarted(description);
        }
    }

    public void testIgnored(Description description) throws Exception {
        if (this.testingThisTest(description)) {
            StepEventBus.getEventBus().testIgnored();
            this.endTest();
        }
    }

    public List<TestOutcome> getTestOutcomes() {
        return this.baseStepListener.getTestOutcomes();
    }

    public FailureCause getError() {
        return this.baseStepListener.getTestFailureCause();
    }

    public boolean hasRecordedFailures() {
        return this.baseStepListener.aStepHasFailed();
    }

    public void dropListeners() {
        StepEventBus.getEventBus().dropListener((StepListener)this.baseStepListener);
        for (StepListener listener : this.extraListeners) {
            StepEventBus.getEventBus().dropListener(listener);
        }
    }

    private void startTest() {
        this.testStarted = true;
    }

    private void endTest() {
        this.testStarted = false;
    }

    private boolean testingThisTest(Description description) {
        return description.getTestClass().equals(this.testClass);
    }

    protected Class<?> getTestClass() {
        return this.testClass;
    }
}

