/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.runners;

import com.google.common.base.Optional;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.util.Collection;
import java.util.List;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.injectors.EnvironmentDependencyInjector;
import net.serenitybdd.junit.runners.FailureDetectingStepListener;
import net.serenitybdd.junit.runners.SerenityStatement;
import net.serenitybdd.junit.runners.TestConfiguration;
import net.serenitybdd.junit.runners.TestMethodAnnotations;
import net.serenitybdd.junit.runners.TestMethodConfiguration;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.ManagedWebDriverAnnotatedField;
import net.thucydides.core.annotations.TestCaseAnnotations;
import net.thucydides.core.batches.BatchManager;
import net.thucydides.core.batches.BatchManagerProvider;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.PageObjectDependencyInjector;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.StepPublisher;
import net.thucydides.core.steps.stepdata.StepData;
import net.thucydides.core.tags.TagScanner;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import net.thucydides.junit.listeners.JUnitStepListener;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerenityRunner
extends BlockJUnit4ClassRunner {
    private StepFactory stepFactory;
    private Pages pages;
    private final WebdriverManager webdriverManager;
    private String requestedDriver;
    private ReportService reportService;
    private final TestConfiguration theTest;
    private JUnitStepListener stepListener;
    private PageObjectDependencyInjector dependencyInjector;
    private Configuration configuration;
    private TagScanner tagScanner;
    private BatchManager batchManager;
    private final Logger logger = LoggerFactory.getLogger(SerenityRunner.class);

    public Pages getPages() {
        return this.pages;
    }

    public SerenityRunner(Class<?> klass) throws InitializationError {
        this(klass, Injectors.getInjector());
    }

    public SerenityRunner(Class<?> klass, Module module) throws InitializationError {
        this(klass, Injectors.getInjector((Module)module));
    }

    public SerenityRunner(Class<?> klass, Injector injector) throws InitializationError {
        this(klass, (WebdriverManager)injector.getInstance(WebdriverManager.class), (Configuration)injector.getInstance(Configuration.class), (BatchManager)injector.getInstance(BatchManager.class));
    }

    public SerenityRunner(Class<?> klass, WebDriverFactory webDriverFactory) throws InitializationError {
        this(klass, webDriverFactory, (Configuration)Injectors.getInjector().getInstance(Configuration.class));
    }

    public SerenityRunner(Class<?> klass, WebDriverFactory webDriverFactory, Configuration configuration) throws InitializationError {
        this(klass, webDriverFactory, configuration, new BatchManagerProvider(configuration).get());
    }

    public SerenityRunner(Class<?> klass, WebDriverFactory webDriverFactory, Configuration configuration, BatchManager batchManager) throws InitializationError {
        this(klass, ThucydidesWebDriverSupport.getWebdriverManager((WebDriverFactory)webDriverFactory, (Configuration)configuration), configuration, batchManager);
    }

    public SerenityRunner(Class<?> klass, BatchManager batchManager) throws InitializationError {
        this(klass, (WebdriverManager)Injectors.getInjector().getInstance(WebdriverManager.class), (Configuration)Injectors.getInjector().getInstance(Configuration.class), batchManager);
    }

    public SerenityRunner(Class<?> klass, WebdriverManager webDriverManager, Configuration configuration, BatchManager batchManager) throws InitializationError {
        super(klass);
        this.theTest = TestConfiguration.forClass(klass).withSystemConfiguration(configuration);
        this.webdriverManager = webDriverManager;
        this.configuration = configuration;
        this.requestedDriver = this.getSpecifiedDriver(klass);
        this.tagScanner = new TagScanner(configuration.getEnvironmentVariables());
        if (TestCaseAnnotations.supportsWebTests(klass)) {
            this.checkRequestedDriverType();
        }
        this.batchManager = batchManager;
        batchManager.registerTestCase(klass);
    }

    private String getSpecifiedDriver(Class<?> klass) {
        if (ManagedWebDriverAnnotatedField.hasManagedWebdriverField(klass)) {
            return ManagedWebDriverAnnotatedField.findFirstAnnotatedField(klass).getDriver();
        }
        return null;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected BatchManager getBatchManager() {
        return this.batchManager;
    }

    private void checkRequestedDriverType() {
        if (this.requestedDriverSpecified()) {
            SupportedWebDriver.getDriverTypeFor((String)this.requestedDriver);
        } else {
            this.getConfiguration().getDriverType();
        }
    }

    private boolean requestedDriverSpecified() {
        return !StringUtils.isEmpty((CharSequence)this.requestedDriver);
    }

    public File getOutputDirectory() {
        return this.getConfiguration().getOutputDirectory();
    }

    public void subscribeReporter(AcceptanceTestReporter reporter) {
        this.getReportService().subscribe(reporter);
    }

    public void useQualifier(String qualifier) {
        this.getReportService().useQualifier(qualifier);
    }

    public void run(RunNotifier notifier) {
        if (this.skipThisTest()) {
            return;
        }
        try {
            RunNotifier localNotifier = this.initializeRunNotifier(notifier);
            super.run(localNotifier);
            this.fireNotificationsBasedOnTestResultsTo(notifier);
        }
        catch (Throwable someFailure) {
            someFailure.printStackTrace();
            throw someFailure;
        }
        finally {
            this.notifyTestSuiteFinished();
            this.generateReports();
            this.dropListeners(notifier);
            this.closeDrivers();
        }
    }

    private Optional<TestOutcome> latestOutcome() {
        if (StepEventBus.getEventBus().getBaseStepListener().getTestOutcomes().isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(StepEventBus.getEventBus().getBaseStepListener().getTestOutcomes().get(0));
    }

    private void fireNotificationsBasedOnTestResultsTo(RunNotifier notifier) {
        if (!this.latestOutcome().isPresent()) {
            return;
        }
    }

    private void notifyTestSuiteFinished() {
        try {
            StepEventBus.getEventBus().testSuiteFinished();
        }
        catch (Throwable listenerException) {
            this.logger.error("Test event bus error: " + listenerException.getMessage(), listenerException);
        }
    }

    private void dropListeners(RunNotifier notifier) {
        JUnitStepListener listener = this.getStepListener();
        notifier.removeListener((RunListener)listener);
        this.getStepListener().dropListeners();
    }

    protected void generateReports() {
        this.generateReportsFor(this.getTestOutcomes());
    }

    private boolean skipThisTest() {
        return this.testNotInCurrentBatch();
    }

    private boolean testNotInCurrentBatch() {
        return this.batchManager != null && !this.batchManager.shouldExecuteThisTest(this.getDescription().testCount());
    }

    protected JUnitStepListener getStepListener() {
        if (this.stepListener == null) {
            this.buildAndConfigureListeners();
        }
        return this.stepListener;
    }

    protected void setStepListener(JUnitStepListener stepListener) {
        this.stepListener = stepListener;
    }

    private void buildAndConfigureListeners() {
        this.initStepEventBus();
        if (this.webtestsAreSupported()) {
            WebDriver driver = ThucydidesWebDriverSupport.getWebdriverManager().getWebdriver(this.requestedDriver);
            this.initPagesObjectUsing(driver);
            this.setStepListener(this.initListenersUsing(this.getPages()));
            this.initStepFactoryUsing(this.getPages());
        } else {
            this.setStepListener(this.initListeners());
            this.initStepFactory();
        }
    }

    private RunNotifier initializeRunNotifier(RunNotifier notifier) {
        notifier.addListener((RunListener)this.getStepListener());
        return notifier;
    }

    private boolean shouldRetryTest() {
        return ThucydidesSystemProperty.JUNIT_RETRY_TESTS.booleanFrom(this.configuration.getEnvironmentVariables());
    }

    protected void initStepEventBus() {
        StepEventBus.getEventBus().clear();
    }

    private void initPagesObjectUsing(WebDriver driver) {
        this.pages = new Pages(driver, this.getConfiguration());
        this.dependencyInjector = new PageObjectDependencyInjector(this.pages);
    }

    protected JUnitStepListener initListenersUsing(Pages pageFactory) {
        return JUnitStepListener.withOutputDirectory(this.getConfiguration().getOutputDirectory()).and().withPageFactory(pageFactory).and().withTestClass(this.getTestClass().getJavaClass()).and().build();
    }

    protected JUnitStepListener initListeners() {
        return JUnitStepListener.withOutputDirectory(this.getConfiguration().getOutputDirectory()).and().withTestClass(this.getTestClass().getJavaClass()).and().build();
    }

    private boolean webtestsAreSupported() {
        return TestCaseAnnotations.supportsWebTests((Class)this.getTestClass().getJavaClass());
    }

    private void initStepFactoryUsing(Pages pagesObject) {
        this.stepFactory = new StepFactory(pagesObject);
    }

    private void initStepFactory() {
        this.stepFactory = new StepFactory();
    }

    private void closeDrivers() {
        this.getWebdriverManager().closeAllDrivers();
    }

    protected WebdriverManager getWebdriverManager() {
        return this.webdriverManager;
    }

    private ReportService getReportService() {
        if (this.reportService == null) {
            this.reportService = new ReportService(this.getOutputDirectory(), this.getDefaultReporters());
        }
        return this.reportService;
    }

    private void generateReportsFor(List<TestOutcome> testOutcomeResults) {
        this.getReportService().generateReportsFor(testOutcomeResults);
        this.getReportService().generateConfigurationsReport();
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        TestMethodConfiguration theMethod = TestMethodConfiguration.forMethod(method);
        this.clearMetadataIfRequired();
        if (this.shouldSkipTest(method)) {
            return;
        }
        if (theMethod.isManual()) {
            this.markAsManual(method);
            notifier.fireTestIgnored(this.describeChild(method));
            return;
        }
        if (theMethod.isPending()) {
            this.markAsPending(method);
            notifier.fireTestIgnored(this.describeChild(method));
            return;
        }
        this.processTestMethodAnnotationsFor(method);
        FailureDetectingStepListener failureDetectingStepListener = new FailureDetectingStepListener();
        StepEventBus.getEventBus().registerListener((StepListener)failureDetectingStepListener);
        Serenity.initializeTestSession();
        this.prepareBrowserForTest();
        this.additionalBrowserCleanup();
        failureDetectingStepListener.reset();
        super.runChild(method, notifier);
    }

    private void clearMetadataIfRequired() {
        if (this.theTest.shouldClearMetadata()) {
            Serenity.getCurrentSession().clearMetaData();
        }
    }

    protected void additionalBrowserCleanup() {
    }

    private boolean shouldSkipTest(FrameworkMethod method) {
        return !this.tagScanner.shouldRunMethod(this.getTestClass().getJavaClass(), method.getName());
    }

    private void markAsPending(FrameworkMethod method) {
        this.testStarted(method);
        StepEventBus.getEventBus().testPending();
        StepEventBus.getEventBus().testFinished();
    }

    private void markAsManual(FrameworkMethod method) {
        this.testStarted(method);
        StepEventBus.getEventBus().testIsManual();
        StepEventBus.getEventBus().testFinished();
    }

    private void testStarted(FrameworkMethod method) {
        this.getStepListener().testStarted(Description.createTestDescription(method.getMethod().getDeclaringClass(), (String)this.testName(method)));
    }

    private void processTestMethodAnnotationsFor(FrameworkMethod method) {
        if (this.isIgnored(method)) {
            this.testStarted(method);
            StepEventBus.getEventBus().testIgnored();
        }
    }

    protected void prepareBrowserForTest() {
        if (this.theTest.needsToRestartTheBrowser()) {
            WebdriverProxyFactory.resetDriver((WebDriver)this.getDriver());
        }
        if (this.theTest.shouldClearTheBrowserSession()) {
            WebdriverProxyFactory.clearBrowserSession((WebDriver)this.getDriver());
        }
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        if (this.webtestsAreSupported()) {
            this.injectDriverInto(test);
            this.initPagesObjectUsing(this.driverFor(method));
            this.injectAnnotatedPagesObjectInto(test);
            this.initStepFactoryUsing(this.getPages());
        }
        this.injectScenarioStepsInto(test);
        this.injectEnvironmentVariablesInto(test);
        this.useStepFactoryForDataDrivenSteps();
        Statement baseStatement = super.methodInvoker(method, test);
        return new SerenityStatement(baseStatement, (StepPublisher)this.stepListener.getBaseStepListener());
    }

    private void useStepFactoryForDataDrivenSteps() {
        StepData.setDefaultStepFactory((StepFactory)this.stepFactory);
    }

    protected void injectDriverInto(Object testCase) {
        TestCaseAnnotations.forTestCase((Object)testCase).injectDrivers(this.getWebdriverManager());
        this.dependencyInjector.injectDependenciesInto(testCase);
    }

    protected WebDriver driverFor(FrameworkMethod method) {
        if (TestMethodAnnotations.forTest(method).isDriverSpecified()) {
            String testSpecificDriver = TestMethodAnnotations.forTest(method).specifiedDriver();
            return this.getDriver(testSpecificDriver);
        }
        return this.getDriver();
    }

    protected void injectScenarioStepsInto(Object testCase) {
        StepAnnotations.injectScenarioStepsInto((Object)testCase, (StepFactory)this.stepFactory);
    }

    protected void injectAnnotatedPagesObjectInto(Object testCase) {
        StepAnnotations.injectAnnotatedPagesObjectInto((Object)testCase, (Pages)this.pages);
    }

    protected void injectEnvironmentVariablesInto(Object testCase) {
        EnvironmentDependencyInjector environmentDependencyInjector = new EnvironmentDependencyInjector();
        environmentDependencyInjector.injectDependenciesInto(testCase);
    }

    protected WebDriver getDriver() {
        return this.getWebdriverManager().getWebdriver(this.requestedDriver);
    }

    protected WebDriver getDriver(String driver) {
        return this.getWebdriverManager().getWebdriver(driver);
    }

    public List<TestOutcome> getTestOutcomes() {
        return this.getStepListener().getTestOutcomes();
    }

    protected Collection<AcceptanceTestReporter> getDefaultReporters() {
        return ReportService.getDefaultReporters();
    }
}

