/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reflection;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassFinder.class);
    private final ClassLoader classLoader;
    private final Class annotation;

    private ClassFinder(ClassLoader classLoader, Class annotation) {
        this.classLoader = classLoader;
        this.annotation = annotation;
    }

    private ClassFinder(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public static ClassFinder loadClasses() {
        return new ClassFinder(ClassFinder.getDefaultClassLoader());
    }

    public ClassFinder annotatedWith(Class annotation) {
        return new ClassFinder(this.classLoader, annotation);
    }

    public List<Class<?>> fromPackage(String packageName) {
        return this.filtered(ClassFinder.getClasses(packageName));
    }

    private List<Class<?>> filtered(Collection<Class<?>> classes) {
        ArrayList matchingClasses = new ArrayList();
        for (Class<?> clazz : classes) {
            if (!this.matchesConstraints(clazz)) continue;
            matchingClasses.add(clazz);
        }
        return matchingClasses;
    }

    private boolean matchesConstraints(Class clazz) {
        if (this.annotation == null) {
            return true;
        }
        return clazz.getAnnotation(this.annotation) != null;
    }

    private static ClassLoader getDefaultClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static boolean isNotAnInnerClass(String className) {
        return !className.contains("$");
    }

    public static List<Class<?>> getClasses(String packageName) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            assert (classLoader != null);
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(path);
            ArrayList<URI> dirs = new ArrayList<URI>();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                dirs.add(resource.toURI());
            }
            TreeSet<String> classes = new TreeSet<String>();
            for (URI directory : dirs) {
                classes.addAll(ClassFinder.findClasses(directory, packageName));
            }
            ArrayList classList = new ArrayList();
            for (String className : classes) {
                try {
                    if (!className.startsWith(packageName) || !ClassFinder.isNotAnInnerClass(className)) continue;
                    classList.add(Class.forName(className));
                }
                catch (Throwable e) {
                    LOGGER.debug("Could not load class {}", (Object)className);
                }
            }
            return classList;
        }
        catch (Exception e) {
            return Collections.EMPTY_LIST;
        }
    }

    private static TreeSet<String> findClasses(URI directory, String packageName) throws Exception {
        String scheme = directory.getScheme();
        String schemeSpecificPart = directory.getSchemeSpecificPart();
        if (scheme.equals("jar") && schemeSpecificPart.contains("!")) {
            return ClassFinder.findClassesInJar(directory);
        }
        if (scheme.equals("file")) {
            return ClassFinder.findClassesInFileSystemDirectory(directory, packageName);
        }
        throw new IllegalArgumentException("cannot handle URI with scheme [" + scheme + "]; received directory=[" + directory + "], packageName=[" + packageName + "]");
    }

    private static TreeSet<String> findClassesInJar(URI jarDirectory) throws Exception {
        String schemeSpecificPart = jarDirectory.getSchemeSpecificPart();
        TreeSet<String> classes = new TreeSet<String>();
        String[] split = schemeSpecificPart.split("!");
        URL jar = new URL(split[0]);
        try (ZipInputStream zip = new ZipInputStream(jar.openStream());){
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                String className;
                if (!entry.getName().endsWith(".class") || !ClassFinder.isNotAnInnerClass(className = ClassFinder.classNameFor(entry))) continue;
                classes.add(className);
            }
        }
        return classes;
    }

    private static TreeSet<String> findClassesInFileSystemDirectory(URI fileSystemDirectory, String packageName) throws Exception {
        File[] files;
        TreeSet<String> classes = new TreeSet<String>();
        File dir = new File(fileSystemDirectory);
        if (!dir.exists()) {
            return classes;
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                classes.addAll(ClassFinder.findClassesInFileSystemDirectory(file.getAbsoluteFile().toURI(), packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(packageName + '.' + file.getName().substring(0, file.getName().length() - 6));
        }
        return classes;
    }

    private static String classNameFor(ZipEntry entry) {
        return entry.getName().replaceAll("[$].*", "").replaceAll("[.]class", "").replace('/', '.');
    }
}

