/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.templates;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Version;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.thucydides.core.reports.templates.FreemarkerReportTemplate;
import net.thucydides.core.reports.templates.ReportTemplate;
import net.thucydides.core.reports.templates.TemplateManager;

public class FreeMarkerTemplateManager
implements TemplateManager {
    public static final Version FREEMARKER_VERSION = new Version(2, 3, 23);
    Configuration cfg;
    Map<String, ReportTemplate> templateCache = new ConcurrentHashMap<String, ReportTemplate>();

    public FreeMarkerTemplateManager() throws Exception {
        this.cfg = new Configuration(FREEMARKER_VERSION);
        this.cfg.setNumberFormat("0.######");
        this.cfg.setLocale(Locale.UK);
        this.cfg.setClassForTemplateLoading(this.getClass(), "/");
        this.cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
    }

    @Override
    public ReportTemplate getTemplateFrom(String template) throws Exception {
        if (!this.templateCache.containsKey(template)) {
            this.templateCache.put(template, new FreemarkerReportTemplate(this.cfg, template));
        }
        return this.templateCache.get(template);
    }
}

