/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Optional;

public class OverviewReader {
    public Optional<String> readOverviewFrom(String ... featureDirectories) {
        Optional<File> overviewFile = Arrays.stream(featureDirectories).map(featureDirectory -> this.findOverviewFileIn((String)featureDirectory)).filter(Optional::isPresent).map(Optional::get).findFirst();
        try {
            return overviewFile.isPresent() ? Optional.of(new String(Files.readAllBytes(overviewFile.get().toPath()))) : Optional.empty();
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private Optional<File> findOverviewFileIn(String featureDirectory) {
        if (new File(featureDirectory + "/overview.txt").exists()) {
            return Optional.of(new File(featureDirectory + "/overview.txt"));
        }
        if (new File(featureDirectory + "/overview.md").exists()) {
            return Optional.of(new File(featureDirectory + "/overview.md"));
        }
        return Optional.empty();
    }
}

