/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.environment;

import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.serenitybdd.core.environment.UndefinedEnvironmentVariableException;
import net.thucydides.core.util.EnvironmentVariables;

public class EnvironmentSpecificConfiguration {
    private EnvironmentVariables environmentVariables;
    private EnvironmentStrategy environmentStrategy;
    private Function<String, String> contextlessProperty = property -> this.environmentVariables.getProperty((String)property);
    private Function<String, String> defaultProperty = property -> {
        String candidateValue = this.propertyForAllEnvironments((String)property);
        if (candidateValue == null) {
            candidateValue = this.propertyForDefaultEnvironment((String)property);
        }
        if (candidateValue == null) {
            candidateValue = this.contextlessProperty.apply((String)property);
        }
        return this.substituteProperties(candidateValue);
    };
    private Function<String, String> propertyForADefinedEnvironment = property -> {
        String environmentProperty = this.environmentVariables.getProperty("environments." + EnvironmentSpecificConfiguration.getDefinedEnvironment(this.environmentVariables) + "." + property);
        if (environmentProperty == null) {
            environmentProperty = this.propertyForAllEnvironments((String)property);
        }
        return environmentProperty == null ? this.defaultProperty.apply((String)property) : environmentProperty;
    };
    private final Pattern VARIABLE_EXPRESSION_PATTERN = Pattern.compile("#\\{([^}]*)\\}");

    public static boolean areDefinedIn(EnvironmentVariables environmentVariables) {
        return !environmentVariables.getPropertiesWithPrefix("environments.").isEmpty();
    }

    private String propertyForAllEnvironments(String propertyName) {
        return this.environmentVariables.getProperty("environments.all." + propertyName);
    }

    private String propertyForDefaultEnvironment(String propertyName) {
        return this.environmentVariables.getProperty("environments.default." + propertyName);
    }

    private static String getDefinedEnvironment(EnvironmentVariables environmentVariables) {
        return environmentVariables.getProperty("environment");
    }

    public EnvironmentSpecificConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.environmentStrategy = EnvironmentSpecificConfiguration.environmentStrategyDefinedIn(environmentVariables);
    }

    public String getProperty(String propertyName) {
        return this.getOptionalProperty(propertyName).orElseThrow(() -> new UndefinedEnvironmentVariableException("Environment '" + propertyName + "' property undefined for environment '" + EnvironmentSpecificConfiguration.getDefinedEnvironment(this.environmentVariables) + "'"));
    }

    public Optional<String> getOptionalProperty(String ... propertyNames) {
        String propertyName;
        String propertyValue = null;
        String[] stringArray = propertyNames;
        int n = stringArray.length;
        for (int i = 0; i < n && (propertyValue = this.getPropertyValue(propertyName = stringArray[i])) == null; ++i) {
        }
        if (propertyValue == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.substituteProperties(propertyValue));
    }

    private String substituteProperties(String propertyValue) {
        if (propertyValue == null) {
            return propertyValue;
        }
        Matcher matcher = this.VARIABLE_EXPRESSION_PATTERN.matcher(propertyValue);
        while (matcher.find()) {
            String nestedProperty = matcher.group().substring(2, matcher.group().length() - 1);
            String value = this.getPropertyValue(nestedProperty);
            if (value == null) continue;
            propertyValue = matcher.replaceFirst(value);
        }
        return propertyValue;
    }

    public String getPropertyValue(String propertyName) {
        switch (this.environmentStrategy) {
            case USE_NORMAL_PROPERTIES: {
                return this.contextlessProperty.apply(propertyName);
            }
            case USE_DEFAULT_PROPERTIES: {
                return this.defaultProperty.apply(propertyName);
            }
            case ENVIRONMENT_CONFIGURED_AND_NAMED: {
                return this.propertyForADefinedEnvironment.apply(propertyName);
            }
        }
        return null;
    }

    public static EnvironmentSpecificConfiguration from(EnvironmentVariables environmentVariables) {
        return new EnvironmentSpecificConfiguration(environmentVariables);
    }

    private static EnvironmentStrategy environmentStrategyDefinedIn(EnvironmentVariables environmentVariables) {
        boolean defaultEnvironmentsAreConfigured;
        boolean environmentsAreConfigured = !environmentVariables.getPropertiesWithPrefix("environments.").isEmpty();
        boolean environmentIsSpecified = environmentVariables.getProperty("environment") != null;
        boolean bl = defaultEnvironmentsAreConfigured = !environmentVariables.getPropertiesWithPrefix("environments.default.").isEmpty();
        if (!environmentsAreConfigured) {
            return EnvironmentStrategy.USE_NORMAL_PROPERTIES;
        }
        if (EnvironmentSpecificConfiguration.specifiedEnvironmentNotConfiguredIn(environmentVariables)) {
            return EnvironmentStrategy.USE_DEFAULT_PROPERTIES;
        }
        if (defaultEnvironmentsAreConfigured && !environmentIsSpecified) {
            return EnvironmentStrategy.USE_DEFAULT_PROPERTIES;
        }
        if (!environmentIsSpecified) {
            return EnvironmentStrategy.ENVIRONMENT_CONFIGURED_BUT_NOT_NAMED;
        }
        return EnvironmentStrategy.ENVIRONMENT_CONFIGURED_AND_NAMED;
    }

    private static boolean specifiedEnvironmentNotConfiguredIn(EnvironmentVariables environmentVariables) {
        String environment = EnvironmentSpecificConfiguration.getDefinedEnvironment(environmentVariables);
        return environment != null && environmentVariables.getPropertiesWithPrefix("environments." + environment + ".").isEmpty();
    }

    static enum EnvironmentStrategy {
        USE_NORMAL_PROPERTIES,
        USE_DEFAULT_PROPERTIES,
        ENVIRONMENT_CONFIGURED_AND_NAMED,
        ENVIRONMENT_CONFIGURED_BUT_NOT_NAMED,
        USE_DEFAULT_CONFIGURATION,
        NO_ENVIRONMENT_DEFINED;

    }
}

