/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.decorators.request;

import com.jayway.restassured.internal.RequestSpecificationImpl;
import com.jayway.restassured.internal.assertion.AssertParameter;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.FilterableRequestSpecification;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.rest.RestMethod;
import net.serenitybdd.rest.decorators.request.RequestSpecificationAdvancedConfiguration;
import net.serenitybdd.rest.stubs.ResponseStub;
import net.serenitybdd.rest.utils.RestExecutionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSpecificationDecorated
extends RequestSpecificationAdvancedConfiguration
implements FilterableRequestSpecification {
    private static final Logger log = LoggerFactory.getLogger(RequestSpecificationDecorated.class);
    private Response lastResponse;

    public RequestSpecificationDecorated(RequestSpecificationImpl core) {
        super(core);
    }

    public Response get() {
        return this.get("", new Object[0]);
    }

    public Response get(URL url) {
        return this.get(((URL)AssertParameter.notNull((Object)url, (String)"URL")).toString(), new Object[0]);
    }

    public Response get(String path, Object ... pathParams) {
        return this.execute(RestMethod.GET, path, pathParams);
    }

    public Response get(String path, Map<String, ?> pathParams) {
        this.pathParameters((Map)pathParams);
        return this.get(path, new Object[0]);
    }

    public Response get(URI uri) {
        return this.get(((URI)AssertParameter.notNull((Object)uri, (String)"URI")).toString(), new Object[0]);
    }

    public Response post() {
        return this.post("", new Object[0]);
    }

    public Response post(URL url) {
        return this.post(((URL)AssertParameter.notNull((Object)url, (String)"URL")).toString(), new Object[0]);
    }

    public Response post(String path, Object ... pathParams) {
        return this.execute(RestMethod.POST, path, pathParams);
    }

    public Response post(String path, Map<String, ?> pathParams) {
        this.pathParameters((Map)pathParams);
        return this.post(path, new Object[0]);
    }

    public Response post(URI uri) {
        return this.post(((URI)AssertParameter.notNull((Object)uri, (String)"URI")).toString(), new Object[0]);
    }

    public Response put() {
        return this.put("", new Object[0]);
    }

    public Response put(URL url) {
        return this.put(((URL)AssertParameter.notNull((Object)url, (String)"URL")).toString(), new Object[0]);
    }

    public Response put(URI uri) {
        return this.put(((URI)AssertParameter.notNull((Object)uri, (String)"URI")).toString(), new Object[0]);
    }

    public Response put(String path, Object ... pathParams) {
        return this.execute(RestMethod.PUT, path, pathParams);
    }

    public Response put(String path, Map<String, ?> pathParams) {
        this.pathParameters((Map)pathParams);
        return this.put(path, new Object[0]);
    }

    public Response delete() {
        return this.delete("", new Object[0]);
    }

    public Response delete(URL url) {
        return this.delete(((URL)AssertParameter.notNull((Object)url, (String)"URL")).toString(), new Object[0]);
    }

    public Response delete(URI uri) {
        return this.delete(((URI)AssertParameter.notNull((Object)uri, (String)"URI")).toString(), new Object[0]);
    }

    public Response delete(String path, Object ... pathParams) {
        return this.execute(RestMethod.DELETE, path, pathParams);
    }

    public Response delete(String path, Map<String, ?> pathParams) {
        this.pathParameters((Map)pathParams);
        return this.delete(path, new Object[0]);
    }

    public Response head() {
        return this.head("", new Object[0]);
    }

    public Response head(URL url) {
        return this.head(((URL)AssertParameter.notNull((Object)url, (String)"URL")).toString(), new Object[0]);
    }

    public Response head(URI uri) {
        return this.head(((URI)AssertParameter.notNull((Object)uri, (String)"URI")).toString(), new Object[0]);
    }

    public Response head(String path, Object ... pathParams) {
        return this.execute(RestMethod.HEAD, path, pathParams);
    }

    public Response head(String path, Map<String, ?> pathParams) {
        this.pathParameters((Map)pathParams);
        return this.head(path, new Object[0]);
    }

    public Response patch() {
        return this.patch("", new Object[0]);
    }

    public Response patch(URL url) {
        return this.patch(((URL)AssertParameter.notNull((Object)url, (String)"URL")).toString(), new Object[0]);
    }

    public Response patch(URI uri) {
        return this.patch(((URI)AssertParameter.notNull((Object)uri, (String)"URI")).toString(), new Object[0]);
    }

    public Response patch(String path, Object ... pathParams) {
        return this.execute(RestMethod.PATCH, path, pathParams);
    }

    public Response patch(String path, Map<String, ?> pathParams) {
        this.pathParameters((Map)pathParams);
        return this.patch(path, new Object[0]);
    }

    public Response options() {
        return this.options("", new Object[0]);
    }

    public Response options(String path, Object ... pathParams) {
        return this.execute(RestMethod.OPTIONS, path, pathParams);
    }

    public Response options(String path, Map<String, ?> pathParams) {
        this.pathParameters((Map)pathParams);
        return this.options(path, new Object[0]);
    }

    public Response options(URI uri) {
        return this.options(((URI)AssertParameter.notNull((Object)uri, (String)"URI")).toString(), new Object[0]);
    }

    public Response options(URL url) {
        return this.options(((URL)AssertParameter.notNull((Object)url, (String)"URL")).toString(), new Object[0]);
    }

    protected Response execute(RestMethod method, String path, Object ... pathParams) {
        Response response = null;
        RuntimeException exception = null;
        try {
            switch (method) {
                case POST: {
                    response = this.decorate(this.core.post(path, pathParams));
                    break;
                }
                case GET: {
                    response = this.decorate(this.core.get(path, pathParams));
                    break;
                }
                case DELETE: {
                    response = this.decorate(this.core.delete(path, pathParams));
                    break;
                }
                case PUT: {
                    response = this.decorate(this.core.put(path, pathParams));
                    break;
                }
                case HEAD: {
                    response = this.decorate(this.core.head(path, pathParams));
                    break;
                }
                case OPTIONS: {
                    response = this.decorate(this.core.options(path, pathParams));
                    break;
                }
                case PATCH: {
                    response = this.decorate(this.core.patch(path, pathParams));
                }
            }
            if (RestExecutionHelper.restCallsAreEnabled()) {
                response = this.stubbed();
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        if (exception != null) {
            if (Serenity.shouldThrowErrorsImmediately()) {
                throw exception;
            }
            response = this.stubbed();
            this.reporting.registerCall(method, this, path, exception, pathParams);
        } else {
            this.reporting.registerCall(method, response, this, path, pathParams);
        }
        this.lastResponse = response;
        return response;
    }

    public Response getLastResponse() {
        return this.lastResponse;
    }

    private Response stubbed() {
        return new ResponseStub();
    }
}

