/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.decorators.request;

import com.google.common.base.Preconditions;
import com.jayway.restassured.internal.MapCreator;
import com.jayway.restassured.internal.RequestSpecificationImpl;
import com.jayway.restassured.response.Cookie;
import com.jayway.restassured.response.Cookies;
import com.jayway.restassured.specification.FilterableRequestSpecification;
import com.jayway.restassured.specification.RequestSpecification;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import net.serenitybdd.rest.decorators.request.RequestSpecificationSecurityConfigurations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RequestSpecificationCookieConfigurations
extends RequestSpecificationSecurityConfigurations
implements FilterableRequestSpecification {
    private static final Logger log = LoggerFactory.getLogger(RequestSpecificationCookieConfigurations.class);

    public RequestSpecificationCookieConfigurations(RequestSpecificationImpl core) {
        super(core);
    }

    public Cookies getCookies() {
        return this.core.getCookies();
    }

    public RequestSpecification cookies(Map<String, ?> cookies) {
        Preconditions.checkNotNull(cookies, (Object)"cookies");
        LinkedList<Cookie> list = new LinkedList<Cookie>();
        for (Map.Entry<String, ?> cookie : cookies.entrySet()) {
            list.add(new Cookie.Builder(cookie.getKey(), this.serializeIfNeeded(cookie.getValue())).build());
        }
        return this.cookies(new Cookies(list));
    }

    public RequestSpecification cookies(Cookies cookies) {
        Preconditions.checkNotNull((Object)cookies, (Object)"cookies");
        this.core.cookies(cookies);
        return this;
    }

    public RequestSpecification cookie(String cookieName, Object value, Object ... additionalValues) {
        LinkedList<Cookie> list = new LinkedList<Cookie>();
        list.add(new Cookie.Builder(cookieName, this.serializeIfNeeded(value)).build());
        for (Object additionalValue : additionalValues) {
            list.add(new Cookie.Builder(cookieName, this.serializeIfNeeded(additionalValue)).build());
        }
        return this.cookies(new Cookies(list));
    }

    public RequestSpecification cookie(String cookieName) {
        return this.cookie(cookieName, null, new Object[0]);
    }

    public RequestSpecification cookie(Cookie cookie) {
        Preconditions.checkNotNull((Object)cookie, (Object)"Cookie");
        return this.cookies(new Cookies(Arrays.asList(cookie)));
    }

    public RequestSpecification cookies(String firstCookieName, Object firstCookieValue, Object ... cookieNameValuePairs) {
        return this.cookies(MapCreator.createMapFromParams((String)firstCookieName, (Object)firstCookieValue, (Object[])cookieNameValuePairs));
    }

    protected String serializeIfNeeded(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return (String)this.helper.executeFunction("serializeIfNeeded", new Class[]{Object.class}, object);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not execute serializeIfNeeded from request, SerenityRest can work incorrectly", e);
        }
    }
}

