/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.decorators.request;

import com.google.common.base.Preconditions;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.RequestSpecificationImpl;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.mapper.ObjectMapper;
import com.jayway.restassured.specification.FilterableRequestSpecification;
import com.jayway.restassured.specification.RequestSpecification;
import java.io.File;
import java.io.InputStream;
import net.serenitybdd.rest.HeaderNames;
import net.serenitybdd.rest.decorators.request.RequestSpecificationHeaderConfigurations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RequestSpecificationBodyConfigurations
extends RequestSpecificationHeaderConfigurations
implements FilterableRequestSpecification {
    private static final Logger log = LoggerFactory.getLogger(RequestSpecificationBodyConfigurations.class);

    public RequestSpecificationBodyConfigurations(RequestSpecificationImpl core) {
        super(core);
    }

    public <T> T getBody() {
        return (T)this.core.getBody();
    }

    public RequestSpecification body(Object object) {
        this.core.body(object);
        return this;
    }

    public RequestSpecification body(Object object, ObjectMapper mapper) {
        this.core.body(object, mapper);
        return this;
    }

    public RequestSpecification body(Object object, ObjectMapperType mapperType) {
        this.core.body(object, mapperType);
        return this;
    }

    public String getRequestContentType() {
        return this.core.getRequestContentType();
    }

    public RequestSpecification body(String body) {
        return this.body((Object)body);
    }

    public RequestSpecification body(byte[] body) {
        return this.body((Object)body);
    }

    public RequestSpecification body(File body) {
        return this.body((Object)body);
    }

    public RequestSpecification body(InputStream body) {
        return this.body((Object)body);
    }

    public RequestSpecification content(String content) {
        return this.content((Object)content);
    }

    public RequestSpecification content(byte[] content) {
        return this.content((Object)content);
    }

    public RequestSpecification content(File content) {
        return this.content((Object)content);
    }

    public RequestSpecification content(InputStream content) {
        return this.content((Object)content);
    }

    public RequestSpecification content(Object object) {
        return this.body(object);
    }

    public RequestSpecification content(Object object, ObjectMapperType mapperType) {
        return this.body(object, mapperType);
    }

    public RequestSpecification content(Object object, ObjectMapper mapper) {
        return this.body(object, mapper);
    }

    public RequestSpecification contentType(ContentType contentType) {
        Preconditions.checkNotNull((Object)contentType, ContentType.class);
        return this.header(HeaderNames.CONTENT_TYPE.asString(), contentType, new Object[0]);
    }

    public RequestSpecification contentType(String contentType) {
        Preconditions.checkNotNull((Object)contentType, (Object)"Content-Type header cannot be null");
        return this.header(HeaderNames.CONTENT_TYPE.asString(), contentType, new Object[0]);
    }
}

