/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.resolver.dc.MappingStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;

public abstract class AbstractMappingStrategy<T>
implements MappingStrategy<T> {
    @Nonnull
    @NonnullElements
    private Map<String, String> resultRenamingMap = Collections.emptyMap();
    private boolean noResultAnError;
    private boolean multipleResultsAnError;

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Map<String, String> getResultRenamingMap() {
        return ImmutableMap.copyOf(this.resultRenamingMap);
    }

    public void setResultRenamingMap(@Nonnull @NonnullElements Map<String, String> map) {
        Constraint.isNotNull(map, (String)"Renaming map cannot be null");
        this.resultRenamingMap = new HashMap<String, String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.resultRenamingMap.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean isNoResultAnError() {
        return this.noResultAnError;
    }

    public void setNoResultAnError(boolean isAnError) {
        this.noResultAnError = isAnError;
    }

    public boolean isMultipleResultsAnError() {
        return this.multipleResultsAnError;
    }

    public void setMultipleResultsAnError(boolean isAnError) {
        this.multipleResultsAnError = isAnError;
    }
}

