/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.dom;

import com.gargoylesoftware.css.util.LangUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;

public class CSSRuleListImpl
implements CSSRuleList,
Serializable {
    private List<CSSRule> rules_ = new ArrayList<CSSRule>();

    public List<CSSRule> getRules() {
        return this.rules_;
    }

    @Override
    public int getLength() {
        return this.getRules().size();
    }

    @Override
    public CSSRule item(int index) {
        if (index < 0 || null == this.rules_ || index >= this.rules_.size()) {
            return null;
        }
        return this.rules_.get(index);
    }

    public void add(CSSRule rule) {
        this.getRules().add(rule);
    }

    public void insert(CSSRule rule, int index) {
        this.getRules().add(index, rule);
    }

    public void delete(int index) {
        this.getRules().remove(index);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.getLength(); ++i) {
            if (i > 0) {
                sb.append("\r\n");
            }
            CSSRule rule = this.item(i);
            sb.append(rule.toString());
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSRuleList)) {
            return false;
        }
        CSSRuleList crl = (CSSRuleList)obj;
        return this.equalsRules(crl);
    }

    private boolean equalsRules(CSSRuleList crl) {
        if (crl == null || this.getLength() != crl.getLength()) {
            return false;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            CSSRule cssRule2;
            CSSRule cssRule1 = this.item(i);
            if (LangUtils.equals(cssRule1, cssRule2 = crl.item(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.rules_);
        return hash;
    }
}

