/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.java.ecc;

import djb.Curve25519;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;

public class KeyHolder {
    protected static final MessageDigest MESSAGE_DIGEST_SHA_256;
    protected final byte[] mPrivateKey;
    protected final byte[] mOriginalPrivateKey;
    protected final byte[] mPublicKeyDiffieHellman;
    protected final byte[] mPublicKeySignature;

    public static byte[] createPrivateKey(byte[] seed) {
        MESSAGE_DIGEST_SHA_256.reset();
        return MESSAGE_DIGEST_SHA_256.digest(seed);
    }

    public KeyHolder(byte[] privateKey) {
        if (privateKey == null || privateKey.length != 32 && privateKey.length != 64) {
            throw new IllegalArgumentException("private key must contain 32 or 64 bytes.");
        }
        this.mOriginalPrivateKey = Arrays.copyOf(privateKey, privateKey.length);
        this.mPrivateKey = Arrays.copyOf(this.mOriginalPrivateKey, this.mOriginalPrivateKey.length);
        Curve25519.clamp(this.mPrivateKey);
        this.mPublicKeyDiffieHellman = new byte[32];
        Curve25519.keygen(this.mPublicKeyDiffieHellman, null, this.mPrivateKey);
        this.mPublicKeySignature = this.computePublicSignatureKey(this.mPrivateKey);
    }

    public KeyHolder(byte[] publicKeyDiffieHellman, byte[] publicKeySignature) {
        this(null, publicKeyDiffieHellman, publicKeySignature);
    }

    public KeyHolder(byte[] privateKey, byte[] publicKeyDiffieHellman, byte[] publicKeySignature) {
        this.mPrivateKey = privateKey;
        this.mOriginalPrivateKey = privateKey;
        this.mPublicKeyDiffieHellman = publicKeyDiffieHellman;
        this.mPublicKeySignature = publicKeySignature;
    }

    protected byte[] computePublicSignatureKey(byte[] privateKey) {
        EdDSAPrivateKeySpec edDSAPrivateKeySpec = new EdDSAPrivateKeySpec(privateKey, EdDSANamedCurveTable.getByName("ed25519-sha-512"));
        return edDSAPrivateKeySpec.getA().toByteArray();
    }

    public byte[] getPrivateKey() {
        return this.mPrivateKey;
    }

    public byte[] getPrivateKeyUnclamped() {
        return this.mOriginalPrivateKey;
    }

    public byte[] getPublicKeyDiffieHellman() {
        return this.mPublicKeyDiffieHellman;
    }

    public byte[] getPublicKeySignature() {
        return this.mPublicKeySignature;
    }

    static {
        try {
            MESSAGE_DIGEST_SHA_256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

