/*
 * Decompiled with CFR 0.152.
 */
package net.vsame.url2sql.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.vsame.url2sql.utils.PostParam;

public class HttpsUtils {
    public static String get(String url, String ... params) {
        return HttpsUtils.get(url, Charset.forName("utf-8"), params);
    }

    private static void https(URLConnection conn) throws Exception {
        if (conn instanceof HttpsURLConnection) {
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            HttpsURLConnection https = (HttpsURLConnection)conn;
            https.setSSLSocketFactory(ssf);
        }
    }

    public static String get(String url, Charset charset, String ... params) {
        String result = "";
        InputStream in = null;
        if (null != params && !params.equals("")) {
            url = url.contains("?") ? url + "&" + params : url + "?" + params;
        }
        try {
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            conn.setConnectTimeout(60000);
            conn.setReadTimeout(300000);
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            HttpsUtils.https(conn);
            conn.connect();
            in = conn.getInputStream();
            result = HttpsUtils.readInputStream(charset, in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {}
        }
        return result;
    }

    public static String post(String url, String ... params) {
        return HttpsUtils.post(url, Charset.forName("utf-8"), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Charset charset, String ... params) {
        PrintWriter out = null;
        InputStream in = null;
        String result = "";
        try {
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.setConnectTimeout(60000);
            conn.setReadTimeout(300000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            HttpsUtils.https(conn);
            out = new PrintWriter(conn.getOutputStream());
            out.print(HttpsUtils.encodeParams(charset, params));
            out.flush();
            in = conn.getInputStream();
            result = HttpsUtils.readInputStream(charset, in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Exception ex) {}
        }
        return result;
    }

    public static String post(String url, List<PostParam> params, String charset) {
        DataOutputStream out;
        HttpURLConnection conn;
        String BOUNDARY = "---------7d4a6d158c9";
        try {
            URL URI2 = new URL(url);
            conn = (HttpURLConnection)URI2.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.setRequestProperty("Charsert", charset);
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            HttpsUtils.https(conn);
            out = new DataOutputStream(conn.getOutputStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] end_data = ("\r\n--" + BOUNDARY + "--\r\n").getBytes();
        int leng = params.size();
        for (int i = 0; i < leng; ++i) {
            byte[] data;
            PostParam param = params.get(i);
            StringBuilder sb = new StringBuilder();
            sb.append("--");
            sb.append(BOUNDARY);
            sb.append("\r\n");
            sb.append("Content-Disposition: form-data;name=\"" + param.getName() + "\"");
            if (param.getIn() != null) {
                sb.append(";filename=\"" + param.getFileName() + "\"\r\n");
                sb.append("Content-Type:" + param.getContentType() + "\r\n\r\n");
                data = sb.toString().getBytes();
                InputStream in = param.getIn();
                int bytes = 0;
                byte[] bufferOut = new byte[1024];
                try {
                    ((OutputStream)out).write(data);
                    while ((bytes = in.read(bufferOut)) != -1) {
                        ((OutputStream)out).write(bufferOut, 0, bytes);
                    }
                    ((OutputStream)out).write("\r\n".getBytes());
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            sb.append("\r\n");
            sb.append("Content-Type:" + param.getContentType() + "\r\n\r\n");
            sb.append(param.getValue() + "\r\n");
            data = sb.toString().getBytes();
            try {
                ((OutputStream)out).write(data);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            ((OutputStream)out).write(end_data);
            ((OutputStream)out).flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {}
        }
        try {
            InputStream in = conn.getInputStream();
            return HttpsUtils.readInputStream(Charset.forName(charset), in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String readInputStream(Charset charset, InputStream in) throws IOException {
        byte[] bytes = new byte[1024];
        int length = -1;
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        while ((length = in.read(bytes)) != -1) {
            byteOutput.write(bytes, 0, length);
        }
        return new String(byteOutput.toByteArray(), charset);
    }

    public static String encodeParams(String ... params) {
        return HttpsUtils.encodeParams(Charset.forName("utf-8"), params);
    }

    private static String encodeParams(Charset charset, String ... params) {
        if (params == null || params.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String str : params) {
            int index = str.indexOf("=");
            if (index == -1) {
                sb.append(str);
            } else {
                try {
                    sb.append(str.substring(0, index)).append("=").append(URLEncoder.encode(str.substring(index + 1), charset.name()));
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
            sb.append("&");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String s = HttpsUtils.get("http://www.baidu.com", "");
        s = HttpsUtils.post("https://www.oschina.net/home/login", "");
        System.out.println(s);
    }

    public static class MyX509TrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

