/*
 * Decompiled with CFR 0.152.
 */
package net.vsame.url2sql.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Properties;

public class JarUtils {
    public static String getJarPath(Class<?> clazz) {
        String path = '/' + clazz.getName().replace('.', '/') + ".class";
        URL u = JarUtils.class.getResource(path);
        if (!"jar".equalsIgnoreCase(u.getProtocol())) {
            return null;
        }
        String file = u.getFile();
        return file.substring(0, file.length() - path.length() - 2);
    }

    public static String getJarName(Class<?> jarClazz) {
        String file = JarUtils.getJarPath(jarClazz);
        if (file == null) {
            return null;
        }
        return new File(file).getName();
    }

    public static URL getResourceFromJar(Class<?> jarClazz, String resource) {
        String file = JarUtils.getJarPath(jarClazz);
        if (file == null) {
            return JarUtils.getResourceFromClassPath(resource);
        }
        if (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        try {
            Enumeration<URL> res = jarClazz.getClassLoader().getResources(resource);
            while (res.hasMoreElements()) {
                URL url = res.nextElement();
                if (!url.getFile().startsWith(file)) continue;
                return url;
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public static InputStream getResourceAsStreamFromJar(Class<?> jarClazz, String resource) {
        URL url = JarUtils.getResourceFromJar(jarClazz, resource);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static URL getResourceFromClassPath(String resource) {
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        return JarUtils.class.getResource(resource);
    }

    public static InputStream getResourceAsStreamFromClassPath(String resource) {
        URL url = JarUtils.getResourceFromClassPath(resource);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(InputStream in) {
        if (in == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            try {
                properties.load(in);
            }
            finally {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public static String readAllText(InputStream in) {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            String tempString = null;
            while ((tempString = br.readLine()) != null) {
                sb.append(tempString).append("\r\n");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    public static String readInputStream(Charset charset, InputStream in) {
        byte[] bytes = new byte[1024];
        int length = -1;
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            while ((length = in.read(bytes)) != -1) {
                byteOutput.write(bytes, 0, length);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new String(byteOutput.toByteArray(), charset);
    }

    public static String readResourceFromJar(Charset charset, Class<?> jarClazz, String resource) {
        InputStream in = JarUtils.getResourceAsStreamFromJar(jarClazz, resource);
        return JarUtils.readInputStream(charset, in);
    }

    public static String readResourceFromJar(Class<?> jarClazz, String resource) {
        return JarUtils.readResourceFromJar(Charset.forName("utf-8"), jarClazz, resource);
    }
}

