/*
 * Decompiled with CFR 0.152.
 */
package net.vsame.url2sql.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.vsame.url2sql.helper.Url2SqlContext;
import net.vsame.url2sql.helper.WebHelper;
import net.vsame.url2sql.render.Render;
import net.vsame.url2sql.url.impl.UrlConfig;
import net.vsame.url2sql.url.impl.UrlMapping;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Url2SqlFilter
implements Filter {
    private static Log LOG = LogFactory.getLog(Url2SqlFilter.class);
    private static String encoding = "utf-8";
    private UrlMapping mapping;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest _req, ServletResponse _resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)_req;
        HttpServletResponse response = (HttpServletResponse)_resp;
        request.setCharacterEncoding(encoding);
        response.setCharacterEncoding(encoding);
        String requestURI = request.getRequestURI().substring(request.getContextPath().length());
        String[] urlNodes = Url2SqlFilter.resolveUrl(requestURI);
        if (urlNodes == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Render render = this.mapping.findRender(urlNodes[1]);
        if (render == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            WebHelper.init(request, response);
            Url2SqlContext c = this.getContext(urlNodes);
            if (c != null) {
                c.setRender(render);
                UrlMapping.getMapping().invoke();
                if (c.getRender() != null) {
                    render = c.getRender();
                }
            }
            if (render.getEncoding() == null) {
                render.setEncoding(encoding);
            }
            render.setContext(request, response).render();
        }
        finally {
            WebHelper.remove();
        }
    }

    private static String[] resolveUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        return new String[]{url.substring(0, index), url.substring(index + 1)};
    }

    private Url2SqlContext getContext(String[] urlNodes) {
        UrlConfig urlConfig = this.mapping.getConfig(urlNodes[0]);
        if (urlConfig == null) {
            return null;
        }
        Url2SqlContext context = WebHelper.getContext();
        context.setRequestUrl(urlNodes[0]);
        context.setExtensionName(urlNodes[1]);
        context.setUrlConfig(urlConfig);
        return context;
    }

    public void init(FilterConfig config) throws ServletException {
        encoding = config.getInitParameter("encoding");
        if (encoding == null || "".equals(encoding)) {
            encoding = "UTF-8";
        }
        LOG.info((Object)("url2sql core init. encoding:" + encoding));
        this.mapping = UrlMapping.getMapping();
        this.mapping.reload(config.getServletContext());
    }

    public void destroy() {
        this.mapping.destroy();
    }
}

