/*
 * Copyright (c) 2002-2003 by OpenSymphony
 * All rights reserved.
 */
/*
 * Generated by XDoclet - Do not edit!
 */
package com.opensymphony.workflow.ejb;


/**
 * Remote interface for Workflow.
 * @author <a href="mailto:plightbo@hotmail.com">Pat Lightbody</a>
 * @author <a href="mailto:hani@formicary.net">Hani Suleiman</a>
 * @version $Revision: 1.7 $
 */
public interface WorkflowRemote extends javax.ejb.EJBObject {
    //~ Methods ////////////////////////////////////////////////////////////////

    public int[] getAvailableActions(long id) throws java.rmi.RemoteException;

    /**
     * Get the available actions for the specified workflow instance.
     * @param id The workflow instance id.
     * @param inputs The inputs map to pass on to conditions
     * @return An array of action id's that can be performed on the specified entry.
     * @throws IllegalArgumentException if the specified id does not exist, or if its workflow descriptor is no longer available or has become invalid.    */
    public int[] getAvailableActions(long id, java.util.Map inputs) throws java.rmi.RemoteException;

    public void setConfiguration(com.opensymphony.workflow.config.Configuration configuration) throws java.rmi.RemoteException;

    public java.util.List getCurrentSteps(long id) throws java.rmi.RemoteException;

    public int getEntryState(long id) throws java.rmi.RemoteException;

    public java.util.List getHistorySteps(long id) throws java.rmi.RemoteException;

    public java.util.Properties getPersistenceProperties() throws java.rmi.RemoteException;

    /**
     * Get the PropertySet for the specified workflow ID
     * @param id The workflow ID    */
    public com.opensymphony.module.propertyset.PropertySet getPropertySet(long id) throws java.rmi.RemoteException;

    public java.util.List getSecurityPermissions(long id) throws java.rmi.RemoteException;

    public java.util.List getSecurityPermissions(long id, java.util.Map inputs) throws java.rmi.RemoteException;

    /**
     * Returns a workflow definition object associated with the given name.
     * @param workflowName the name of the workflow
     * @return the object graph that represents a workflow definition
     */
    public com.opensymphony.workflow.loader.WorkflowDescriptor getWorkflowDescriptor(java.lang.String workflowName) throws java.rmi.RemoteException;

    public java.lang.String getWorkflowName(long id) throws java.rmi.RemoteException;

    /**
     * Get a list of workflow names available
     * @return String[] an array of workflow names.
     */
    public java.lang.String[] getWorkflowNames() throws java.rmi.RemoteException;

    public boolean canInitialize(java.lang.String workflowName, int initialAction) throws java.rmi.RemoteException;

    public boolean canInitialize(java.lang.String workflowName, int initialAction, java.util.Map inputs) throws java.rmi.RemoteException;

    public boolean canModifyEntryState(long id, int newState) throws java.rmi.RemoteException;

    public void changeEntryState(long id, int newState) throws com.opensymphony.workflow.WorkflowException, java.rmi.RemoteException;

    public void doAction(long id, int actionId, java.util.Map inputs) throws com.opensymphony.workflow.WorkflowException, java.rmi.RemoteException;

    public void executeTriggerFunction(long id, int triggerId) throws com.opensymphony.workflow.WorkflowException, java.rmi.RemoteException;

    public long initialize(java.lang.String workflowName, int initialAction, java.util.Map inputs) throws com.opensymphony.workflow.InvalidRoleException, com.opensymphony.workflow.InvalidInputException, com.opensymphony.workflow.StoreException, com.opensymphony.workflow.WorkflowException, java.rmi.RemoteException;

    public java.util.List query(com.opensymphony.workflow.query.WorkflowQuery query) throws com.opensymphony.workflow.StoreException, java.rmi.RemoteException;

    public java.util.List query(com.opensymphony.workflow.query.WorkflowExpressionQuery query) throws com.opensymphony.workflow.WorkflowException, java.rmi.RemoteException;

    public boolean removeWorkflowDescriptor(java.lang.String workflowName) throws com.opensymphony.workflow.FactoryException, java.rmi.RemoteException;

    public boolean saveWorkflowDescriptor(java.lang.String workflowName, com.opensymphony.workflow.loader.WorkflowDescriptor descriptor, boolean replace) throws com.opensymphony.workflow.FactoryException, java.rmi.RemoteException;
}
