/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.loader.WorkflowLoader;
import com.opensymphony.workflow.loader.XMLWorkflowFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class JDBCWorkflowFactory
extends XMLWorkflowFactory
implements FunctionProvider {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$workflow$loader$JDBCWorkflowFactory == null ? (class$com$opensymphony$workflow$loader$JDBCWorkflowFactory = JDBCWorkflowFactory.class$("com.opensymphony.workflow.loader.JDBCWorkflowFactory")) : class$com$opensymphony$workflow$loader$JDBCWorkflowFactory));
    static final String wfTable = "OS_WORKFLOWDEFS";
    static final String wfName = "WF_NAME";
    static final String wfDefinition = "WF_DEFINITION";
    protected DataSource ds;
    protected Map workflows;
    protected boolean reload;
    static /* synthetic */ Class class$com$opensymphony$workflow$loader$JDBCWorkflowFactory;

    public WorkflowDescriptor getWorkflow(String name, boolean validate) throws FactoryException {
        WfConfig c = (WfConfig)this.workflows.get(name);
        if (c == null) {
            throw new RuntimeException("Unknown workflow name \"" + name + "\"");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getWorkflow " + name + " descriptor=" + c.descriptor));
        }
        if (c.descriptor != null) {
            if (this.reload) {
                try {
                    c.descriptor = this.load(c.wfName, validate);
                }
                catch (FactoryException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new FactoryException("Error reloading workflow", e);
                }
            }
        } else {
            try {
                c.descriptor = this.load(c.wfName, validate);
            }
            catch (FactoryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FactoryException("Error loading workflow", e);
            }
        }
        return c.descriptor;
    }

    public String[] getWorkflowNames() {
        int i = 0;
        String[] res = new String[this.workflows.keySet().size()];
        Iterator it = this.workflows.keySet().iterator();
        while (it.hasNext()) {
            res[i++] = (String)it.next();
        }
        return res;
    }

    public void execute(Map transientVars, Map args, PropertySet ps) {
        String name = (String)args.get("name");
        WorkflowDescriptor wfds = (WorkflowDescriptor)transientVars.get("descriptor");
        try {
            this.saveWorkflow(name, wfds, false);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void initDone() throws FactoryException {
        Connection conn = null;
        try {
            this.init();
            this.reload = this.getProperties().getProperty("reload", "false").equalsIgnoreCase("true");
            conn = this.ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT WF_NAME,WF_DEFINITION FROM OS_WORKFLOWDEFS");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                WfConfig config = new WfConfig(name);
                this.workflows.put(rs.getString(1), config);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new FactoryException("Could not read workflow names from datasource", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(String workflowname) throws SQLException {
        byte[] wf = new byte[]{};
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT WF_DEFINITION FROM OS_WORKFLOWDEFS WHERE WF_NAME = ?");
            ps.setString(1, workflowname);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                wf = rs.getBytes(1);
            }
            rs.close();
            ps.close();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
        }
        return wf;
    }

    public boolean removeWorkflow(String name) throws FactoryException {
        boolean removed = false;
        try {
            Connection conn = this.ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("DELETE FROM OS_WORKFLOWDEFS WHERE WF_NAME = ?");
            ps.setString(1, name);
            int rows = ps.executeUpdate();
            if (rows == 1) {
                removed = true;
                this.workflows.remove(name);
            }
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new FactoryException("Unable to remove workflow: " + e.toString(), e);
        }
        return removed;
    }

    public boolean saveWorkflow(String name, WorkflowDescriptor descriptor, boolean replace) throws FactoryException {
        WfConfig c = (WfConfig)this.workflows.get(name);
        if (c != null && !replace) {
            return false;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStreamWriter out = new OutputStreamWriter(bout);
        PrintWriter writer = new PrintWriter(out);
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<!DOCTYPE workflow PUBLIC \"-//OpenSymphony Group//DTD OSWorkflow 2.8//EN\" \"http://www.opensymphony.com/osworkflow/workflow_2_8.dtd\">");
        descriptor.writeXML(writer, 0);
        writer.flush();
        writer.close();
        try {
            boolean bl = this.write(name, bout.toByteArray());
            return bl;
        }
        catch (SQLException e) {
            throw new FactoryException("Unable to save workflow: " + e.toString(), e);
        }
        finally {
            WfConfig config = new WfConfig(name);
            this.workflows.put(name, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(String workflowname, byte[] wf) throws SQLException {
        boolean written = false;
        Connection conn = null;
        try {
            PreparedStatement ps;
            conn = this.ds.getConnection();
            if (this.exists(workflowname, conn)) {
                ps = conn.prepareStatement("UPDATE OS_WORKFLOWDEFS SET WF_DEFINITION = ?WHERE WF_NAME= ?");
                try {
                    ps.setBytes(1, wf);
                }
                catch (Exception e) {
                    // empty catch block
                }
                ps.setString(2, workflowname);
            } else {
                ps = conn.prepareStatement("INSERT INTO OS_WORKFLOWDEFS (WF_NAME, WF_DEFINITION) VALUES (?, ?)");
                ps.setString(1, workflowname);
                try {
                    ps.setBytes(2, wf);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ps.executeUpdate();
            ps.close();
            conn.close();
            written = true;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
        return written;
    }

    private boolean exists(String workflowname, Connection conn) {
        boolean exists = false;
        try {
            PreparedStatement ps = conn.prepareStatement("SELECT WF_NAME FROM OS_WORKFLOWDEFS WHERE WF_NAME = ?");
            ps.setString(1, workflowname);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                exists = true;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            log.fatal((Object)("Could not check if [" + workflowname + "] exists"), (Throwable)e);
        }
        return exists;
    }

    private void init() throws NamingException {
        this.workflows = new HashMap();
        this.ds = (DataSource)new InitialContext().lookup(this.getProperties().getProperty("datasource"));
    }

    private WorkflowDescriptor load(String wfName, boolean validate) throws IOException, SAXException, FactoryException {
        byte[] wf;
        try {
            wf = this.read(wfName);
        }
        catch (SQLException e) {
            throw new FactoryException("Error loading workflow:" + e, e);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(wf);
        return WorkflowLoader.load(is, validate);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class WfConfig {
        String wfName;
        WorkflowDescriptor descriptor;
        long lastModified;

        public WfConfig(String name) {
            this.wfName = name;
        }
    }
}

