/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import webwork.util.BeanUtil;
import webwork.util.StringVariableSubstitutionKit;
import webwork.view.taglib.BasicPropertyTag;
import webwork.view.taglib.ParamTag;

public class WriteTag
extends BasicPropertyTag
implements ParamTag.Parametric {
    private final Map<String, Object> params = new LinkedHashMap<String, Object>();

    protected boolean shouldEscape() {
        return this.escape == null || this.escape != false;
    }

    public void addParameter(String name, Object value) {
        if (value == null) {
            this.params.remove(name);
        } else {
            this.params.put(name, BeanUtil.toStringValue(value));
        }
    }

    public int doStartTag() throws JspException {
        return 2;
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        Object value = this.findValue(this.valueAttr);
        if (this.isNotBlank(value)) {
            this.writeContent(value.toString());
        }
        if (this.isNotBlank(this.bodyContent)) {
            String bodyContent = this.bodyContent.getString();
            this.writeContent(bodyContent);
        }
        return 6;
    }

    private void writeContent(String bodyContent) throws JspException {
        try {
            bodyContent = StringVariableSubstitutionKit.substitue(bodyContent, this.params);
            if (this.shouldEscape()) {
                bodyContent = this.escapeValue(bodyContent);
            }
            this.pageContext.getOut().write(bodyContent);
        }
        catch (IOException ioe) {
            String msg = "Could not show write body content";
            throw new JspException(msg + ", throwable: " + ioe, (Throwable)ioe);
        }
    }

    private boolean isNotBlank(Object value) {
        return value != null && value.toString().length() > 0;
    }
}

