/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.action;

/**
 * This interface can be implemented by actions that wish to be notified if an IllegalArgumentException was thrown when
 * the value of a field was converted from string to the property's type.
 * <p/>
 * Example: an action with a property of type int will get a call to this interface if the value "123a" is supplied.
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.7 $
 */
public interface IllegalArgumentAware
{
    // Public --------------------------------------------------------
    public void addIllegalArgumentException(String fieldName, IllegalArgumentException e);
}
