package webwork.action.factory;

import webwork.action.Action;
import webwork.config.Configuration;
import webwork.util.ClassLoaderUtils;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/**
 * User: hani Date: Nov 7, 2003 Time: 11:38:42 AM
 */
public class ReloadHelperActionFactoryProxy extends ActionFactoryProxy
{
    private File[] files;
    private long[] lastModified;

    public ReloadHelperActionFactoryProxy(ActionFactory aFactory)
    {
        super(aFactory);
        StringTokenizer configFiles = new StringTokenizer((String) Configuration.get("webwork.configuration.xml"), ",");
        List l = new ArrayList(configFiles.countTokens());
        while (configFiles.hasMoreTokens())
        {
            String name = configFiles.nextToken();
            URL fileUrl = ClassLoaderUtils.getResource(name + ".xml", ReloadHelperActionFactoryProxy.class);
            if (fileUrl != null)
            {
                File file = new File(fileUrl.getFile());
                if (file.exists())
                {
                    l.add(file);
                }
            }
        }
        files = new File[l.size()];
        //lets check when they were all modified
        l.toArray(files);
        lastModified = new long[files.length];
        for (int i = 0; i < files.length; i++)
        {
            lastModified[i] = files[i].lastModified();
        }
    }

    public Action getActionImpl(String aName) throws Exception
    {
        for (int i = 0; i < files.length; i++)
        {
            if (files[i].lastModified() > lastModified[i])
            {
                lastModified[i] = files[i].lastModified();
                flushCaches();
            }
        }
        return getNextFactory().getActionImpl(aName);
    }
}
