package webwork.action.factory;

import webwork.action.Action;
import webwork.action.ServletActionContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Hani Suleiman (hani@formicary.net) Date: Dec 30, 2003 Time: 10:16:45 PM
 */
public class SpringActionFactoryProxy extends ActionFactoryProxy
{
    private static final Log log = LogFactory.getLog(SpringActionFactoryProxy.class);

    public SpringActionFactoryProxy(ActionFactory factory)
    {
        super(factory);
    }

    public Action getActionImpl(String aName) throws Exception
    {
        Action action;
        try
        {
            action = (Action) WebApplicationContextUtils.getWebApplicationContext(ServletActionContext.getServletContext()).getBean(aName);
            return (action != null) ? action : getNextFactory().getActionImpl(aName);
        }
        catch (NoSuchBeanDefinitionException ex)
        {
            action = getNextFactory().getActionImpl(aName);
            if (action != null)
            {
                log.warn("No spring bean '" + aName + "' found, using standard instantiation");
            }
        }
        catch (BeansException e)
        {
            action = getNextFactory().getActionImpl(aName);
            log.error("Error getting spring bean " + aName, e);
        }
        return action;
    }
}
