/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.dispatcher;

import webwork.action.Action;
import webwork.action.ResultException;
import webwork.action.ActionContext;
import webwork.action.factory.ActionFactory;

import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Locale;

/**
 * Test dispatcher.
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.17 $
 */
public class TestDispatcher
{
    // Attributes ----------------------------------------------------

    Action action;

    // Public --------------------------------------------------------
    /**
     * Service a request
     *
     * @throws Exception thrown if execution fails
     */
    public String execute(String aName, Map parameters)
            throws Exception
    {
        ActionContext.setName(aName);
        ActionContext.setParameters(Collections.unmodifiableMap(parameters));

        action = ActionFactory.getAction(aName);
        // Execute action
        String result = null;
        try
        {
            //LogFactory.getLog(this.getClass()).debug("Action executing..");
            result = (String) action.execute();
            //Category.getInstance(this.getClass()).debug("Action execution done");
        }
        catch (ResultException e)
        {
            // Show chosen view
            result = (String) e.getResult();
        }

        // Test is ok. Done
        return result;
    }

    public Action getAction(String aName)
            throws Exception
    {
        ActionContext.setName(aName);
        ActionContext.setParameters(Collections.EMPTY_MAP);
        action = ActionFactory.getAction(aName);
        return action;
    }

    public Action getAction(String aName, Map parameters)
            throws Exception
    {
        ActionContext.setName(aName);
        ActionContext.setParameters(Collections.unmodifiableMap(parameters));
        action = ActionFactory.getAction(aName);
        return action;
    }
}
