package webwork.interceptor;

import java.util.List;

public class ChainedInterceptor implements Interceptor
{
    private final List<Interceptor> interceptors;

    public ChainedInterceptor(List<Interceptor> interceptors)
    {
        this.interceptors = interceptors;
    }

    public String intercept(InterceptorChain chain) throws Exception
    {
        return new NestedInterceptorChain(chain, interceptors).proceed();
    }
}