/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.util.editor;

import webwork.action.ValidationEditorSupport;

import java.text.SimpleDateFormat;

/**
 * @author Matt Baldree (matt@smallleap.com)
 * @version $Revision: 1.4 $
 * @see java.beans.PropertyEditorSupport
 * @see ValidationEditorSupport
 * @see FastPropertyEditor
 * @see PropertyEditorException
 */
public class DateFormatEditor extends ValidationEditorSupport implements FastPropertyEditor
{

    public void setAsText(String txt)
    {
        setValue(getAsValue(txt));
    }

    public Object getAsValue(String txt)
    {
        try
        {
            return new SimpleDateFormat(txt);
        }
        catch (Exception e)
        {
            throw new PropertyEditorException(PropertyMessage.BAD_DATEFORMAT, txt);
        }
    }
}

