/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

/**
 * @author Maurice C. Parker (maurice@vineyardenterprise.com)
 * @version $Revision: 1.10 $
 */
public class IfTag
        extends WebWorkTagSupport
{
    // Attributes ----------------------------------------------------
    public final static String ANSWER = "webwork.if.answer";

    protected String test;
    protected boolean answer;

    // Public --------------------------------------------------------

    /**
     * Set the test condition.
     *
     * @param str
     */
    public void setTest(String str)
    {
        test = str;
    }

    // BodyTag implementation ---------------------------------------
    public int doStartTag() throws JspException
    {
        answer = getStack().test(test);
        // Make comparison
        if (answer)
        {
            return EVAL_BODY_INCLUDE;
        }
        else
        {
            return SKIP_BODY;
        }
    }

    public int doEndTag() throws JspException
    {
        if (getId() != null)
        {
            pageContext.setAttribute(getId(), new Boolean(answer));
        }
        pageContext.setAttribute(IfTag.ANSWER, new Boolean(answer));
        answer = false;
        super.doEndTag();
        return EVAL_PAGE;
    }

    public void setParent(Tag t)
    {
        super.setParent(t);
    }

    public void release()
    {
        setId(null);
        super.release();
    }
}



