/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib.ui;

import javax.servlet.jsp.JspException;

/**
 * Select list tag.
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @version $Revision: 1.4 $
 */
public class ComboBoxTag extends AbstractHTMLComponentTag
{
    // Attributes ----------------------------------------------------
    protected String sizeAttr;
    protected String maxlengthAttr;
    protected String onkeyupAttr;
    protected String list;

    // Public --------------------------------------------------------
    public void setSize(String aSize)
    {
        this.sizeAttr = aSize;
    }

    public void setMaxlength(String aMaxlength)
    {
        this.maxlengthAttr = aMaxlength;
    }

    public String getTemplate()
    {
        return "combobox";
    }

    public void setList(String aList)
    {
        this.list = aList;
    }

    public void setOnkeyup(String onkeyup)
    {
        this.onkeyupAttr = onkeyup;
    }

    // BodyTag implementation ----------------------------------------
    public int doEndTag()
            throws JspException
    {
        if (list != null)
        {
            this.addParameter("list", findValue(list));
        }
        if (sizeAttr != null)
        {
            this.addParameter("size", findValue(sizeAttr));
        }
        if (maxlengthAttr != null)
        {
            this.addParameter("maxlength", findValue(maxlengthAttr));
        }
        if (onkeyupAttr != null)
        {
            this.addParameter("onkeyup", findValue(onkeyupAttr));
        }
        return super.doEndTag();
    }
}

