/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib.vui;

import org.apache.commons.logging.*;
import webwork.config.Configuration;
import webwork.util.ContainUtil;
import webwork.view.taglib.IncludeTag;
import webwork.view.taglib.ParamTag;
import webwork.view.taglib.WebWorkBodyTagSupport;

import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import java.util.HashMap;
import java.util.Map;
import java.io.IOException;

/**
 * Voice UI for log tag
 *
 * @author Jeff Haynie (jhaynie@vocalocity.net)
 * @version $Revision: 1.2 $
 */
public class LogTag
        extends AbstractVUITag
{
    // Attributes ----------------------------------------------------
    protected static Log log = LogFactory.getLog(LogTag.class);
    protected String labelAttr;
    protected String exprAttr;

    // Public --------------------------------------------------------

    public String getHeaderTemplate()
    {
        return "log-header.jsp";
    }

    public String getFooterTemplate()
    {
        return "log-footer.jsp";
    }

    public void setLabel(String aName)
    {
        labelAttr = aName;
    }

    public String getLabel()
    {
        return labelAttr;
    }

    public void setExpr(String aName)
    {
        exprAttr = aName;
    }

    public String getExpr()
    {
        return exprAttr;
    }

    protected void initializeAttributes()
    {
        getSetParameter(labelAttr, "label");
        getSetParameter(exprAttr, "expr");
    }
}
