/*
 * Decompiled with CFR 0.152.
 */
package webwork.action.factory;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.LogFactory;
import webwork.action.Action;
import webwork.action.factory.ActionFactory;
import webwork.action.factory.ActionFactoryProxy;
import webwork.config.Configuration;

public class PrefixActionFactoryProxy
extends ActionFactoryProxy {
    private final String[] actionPrefixes;
    private final Map actionNames = new Hashtable();

    public PrefixActionFactoryProxy(ActionFactory aFactory) {
        super(aFactory);
        String actionPrefix = "";
        try {
            actionPrefix = Configuration.getString("webwork.action.packages").trim();
        }
        catch (IllegalArgumentException e) {
            LogFactory.getLog(this.getClass()).info((Object)"Error loading action prefixes. No prefixes will be used");
        }
        StringTokenizer tokens = new StringTokenizer(actionPrefix, ", ");
        ArrayList<String> prefixes = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            prefixes.add(tokens.nextToken());
        }
        this.actionPrefixes = new String[prefixes.size()];
        prefixes.toArray(this.actionPrefixes);
    }

    @Override
    public Action getActionImpl(String aName) throws Exception {
        String actionName = (String)this.actionNames.get(aName);
        if (actionName == null) {
            Action action = null;
            for (int i = 0; i < this.actionPrefixes.length; ++i) {
                try {
                    action = this.getNextFactory().getActionImpl(this.actionPrefixes[i] + "." + aName);
                    if (action == null) continue;
                    this.actionNames.put(aName, this.actionPrefixes[i] + "." + aName);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (action == null) {
                action = this.getNextFactory().getActionImpl(aName);
                this.actionNames.put(aName, aName);
            }
            return action;
        }
        return this.getNextFactory().getActionImpl(actionName);
    }

    @Override
    public void flushCaches() {
        this.getNextFactory().flushCaches();
        this.actionNames.clear();
    }
}

