/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.client;

import com.opensymphony.webwork.dispatcher.client.ClientException;
import com.opensymphony.webwork.dispatcher.client.TransportHttpTrust;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class TransportHttpTrustKeystore
implements TransportHttpTrust {
    private String algorithm;
    private String pathKeyStore;

    @Override
    public boolean isEncrypted() {
        return true;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public Properties serviceInformation() {
        Properties props = new Properties();
        props.setProperty("Trust Manager Overview", "Trusts any X509 certificates or certificate chains in keystore");
        props.setProperty("Trust Manager Keystore File", this.pathKeyStore);
        props.setProperty("Trust Manager Keystore Type", this.algorithm);
        return props;
    }

    @Override
    public SSLSocketFactory start(Properties properties) throws ClientException {
        InputStream inputStream;
        this.pathKeyStore = properties.getProperty("keystoreFile", "key.store");
        char[] passphrase = properties.getProperty("keystorePassword", "password").toCharArray();
        this.algorithm = properties.getProperty("keystoreAlgorithm", "SunX509");
        try {
            File file = new File(this.pathKeyStore);
            if (file.exists()) {
                inputStream = new FileInputStream(file);
            } else {
                URL url = this.getClass().getClassLoader().getResource(this.pathKeyStore);
                if (url == null) {
                    throw new ClientException("Not found");
                }
                inputStream = url.openStream();
            }
        }
        catch (IOException ioe) {
            throw new ClientException(ioe);
        }
        SSLContext ctx = null;
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(inputStream, passphrase);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.algorithm);
            tmf.init(ks);
            ctx = SSLContext.getInstance("TLS");
            ctx.init(null, tmf.getTrustManagers(), null);
            inputStream.close();
        }
        catch (IOException ioe) {
            throw new ClientException(ioe);
        }
        catch (GeneralSecurityException gse) {
            throw new ClientException(gse);
        }
        return ctx.getSocketFactory();
    }
}

