/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.lifecycle;

import com.opensymphony.xwork.interceptor.component.ComponentConfiguration;
import com.opensymphony.xwork.interceptor.component.ComponentManager;
import com.opensymphony.xwork.interceptor.component.DefaultComponentManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestLifecycleFilter
implements Filter {
    private static final Log log = LogFactory.getLog(RequestLifecycleFilter.class);

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        DefaultComponentManager container = this.createComponentManager();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Request DefaultComponentManager : init");
            }
            HttpSession session = ((HttpServletRequest)request).getSession(true);
            ComponentManager fallback = (ComponentManager)session.getAttribute("DefaultComponentManager");
            container.setFallback(fallback);
            ComponentConfiguration config = (ComponentConfiguration)this.getServletContext(session).getAttribute("ComponentConfiguration");
            config.configure((ComponentManager)container, "request");
            request.setAttribute("DefaultComponentManager", (Object)container);
            chain.doFilter(request, response);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Request DefaultComponentManager : dispose");
            }
            container.dispose();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    protected ServletContext getServletContext(HttpSession session) {
        return session.getServletContext();
    }

    protected DefaultComponentManager createComponentManager() {
        return new DefaultComponentManager();
    }
}

