/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.util;

import com.opensymphony.webwork.util.SafeExpressionUtil;
import com.opensymphony.xwork.util.OgnlValueStack;

public interface OgnlValueFinder {
    public Object findValue(String var1);

    public Object findValue(String var1, Class var2);

    public static class Factory {
        public static OgnlValueFinder forStack(OgnlValueStack stack) {
            return Factory.forStack(stack, true);
        }

        private static OgnlValueFinder forStack(final OgnlValueStack stack, final boolean rejectUnsafeExpressions) {
            return new OgnlValueFinder(){

                @Override
                public Object findValue(String expr) {
                    if (rejectUnsafeExpressions && SafeExpressionUtil.isSafeExpression(expr)) {
                        return stack.findValue(expr);
                    }
                    return null;
                }

                @Override
                public Object findValue(String expr, Class asType) {
                    if (rejectUnsafeExpressions && SafeExpressionUtil.isSafeExpression(expr)) {
                        return stack.findValue(expr, asType);
                    }
                    return null;
                }
            };
        }
    }
}

