/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.BitUtil;
import org.agrona.UnsafeAccess;
import sun.nio.ch.DirectBuffer;

public class BufferUtil {
    public static final byte[] NULL_BYTES = "null".getBytes(StandardCharsets.UTF_8);
    public static final ByteOrder NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
    public static final long ARRAY_BASE_OFFSET = UnsafeAccess.UNSAFE.arrayBaseOffset(byte[].class);
    public static final long BYTE_BUFFER_HB_FIELD_OFFSET;
    public static final long BYTE_BUFFER_OFFSET_FIELD_OFFSET;

    public static void boundsCheck(byte[] buffer, long index, int length) {
        int capacity = buffer.length;
        long resultingPosition = index + (long)length;
        if (index < 0L || resultingPosition > (long)capacity) {
            throw new IndexOutOfBoundsException(String.format("index=%d, length=%d, capacity=%d", index, length, capacity));
        }
    }

    public static void boundsCheck(ByteBuffer buffer, long index, int length) {
        int capacity = buffer.capacity();
        long resultingPosition = index + (long)length;
        if (index < 0L || resultingPosition > (long)capacity) {
            throw new IndexOutOfBoundsException(String.format("index=%d, length=%d, capacity=%d", index, length, capacity));
        }
    }

    public static long address(ByteBuffer buffer) {
        return ((DirectBuffer)((Object)buffer)).address();
    }

    public static byte[] array(ByteBuffer buffer) {
        return (byte[])UnsafeAccess.UNSAFE.getObject(buffer, BYTE_BUFFER_HB_FIELD_OFFSET);
    }

    public static int arrayOffset(ByteBuffer buffer) {
        return UnsafeAccess.UNSAFE.getInt(buffer, BYTE_BUFFER_OFFSET_FIELD_OFFSET);
    }

    public static ByteBuffer allocateDirectAligned(int capacity, int alignment) {
        if (!BitUtil.isPowerOfTwo(alignment)) {
            throw new IllegalArgumentException("Must be a power of 2: alignment=" + alignment);
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(capacity + alignment);
        long address = BufferUtil.address(buffer);
        int remainder = (int)(address & (long)(alignment - 1));
        int offset = alignment - remainder;
        buffer.limit(capacity + offset);
        buffer.position(offset);
        return buffer.slice();
    }

    static {
        try {
            BYTE_BUFFER_HB_FIELD_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(ByteBuffer.class.getDeclaredField("hb"));
            BYTE_BUFFER_OFFSET_FIELD_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(ByteBuffer.class.getDeclaredField("offset"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

