/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.RandomAccess;
import java.util.function.LongConsumer;
import java.util.stream.LongStream;

public class LongArrayList
extends AbstractList<Long>
implements List<Long>,
RandomAccess {
    public static final long DEFAULT_NULL_VALUE = Long.MIN_VALUE;
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    public static final int MAX_SIZE = 0x7FFFFFF7;
    private final long nullValue;
    private int size = 0;
    private long[] elements;

    public LongArrayList() {
        this(10, Long.MIN_VALUE);
    }

    public LongArrayList(int initialCapacity, long nullValue) {
        this.nullValue = nullValue;
        this.elements = new long[initialCapacity];
    }

    public LongArrayList(long[] initialElements, int initialSize, long nullValue) {
        this.wrap(initialElements, initialSize);
        this.nullValue = nullValue;
    }

    public void wrap(long[] initialElements, int initialSize) {
        if (initialSize < 0 || initialSize > initialElements.length) {
            throw new IllegalArgumentException("Illegal size " + initialSize + " for array length " + initialElements.length);
        }
        this.elements = initialElements;
        this.size = initialSize;
    }

    public long nullValue() {
        return this.nullValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trimToSize() {
        if (this.elements.length != this.size) {
            this.elements = Arrays.copyOf(this.elements, this.size);
        }
    }

    @Override
    public Long get(int index) {
        long value = this.getLong(index);
        return value == this.nullValue ? null : Long.valueOf(value);
    }

    public long getLong(int index) {
        this.checkIndex(index);
        return this.elements[index];
    }

    @Override
    public boolean add(Long element) {
        return this.addLong(null == element ? this.nullValue : element);
    }

    public boolean addLong(long element) {
        this.ensureCapacity(this.size + 1);
        this.elements[this.size] = element;
        ++this.size;
        return true;
    }

    @Override
    public void add(int index, Long element) {
        this.addLong(index, null == element ? this.nullValue : element);
    }

    public void addLong(int index, long element) {
        this.checkIndexForAdd(index);
        int requiredSize = this.size + 1;
        this.ensureCapacity(requiredSize);
        if (index < this.size) {
            System.arraycopy(this.elements, index, this.elements, index + 1, requiredSize - index);
        }
        this.elements[index] = element;
        ++this.size;
    }

    @Override
    public Long set(int index, Long element) {
        long previous = this.setLong(index, null == element ? this.nullValue : element);
        return this.nullValue == previous ? null : Long.valueOf(previous);
    }

    public long setLong(int index, long element) {
        this.checkIndex(index);
        long previous = this.elements[index];
        this.elements[index] = element;
        return previous;
    }

    public boolean containsLong(long value) {
        return -1 != this.indexOf(value);
    }

    public int indexOf(long value) {
        for (int i = 0; i < this.size; ++i) {
            if (value != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long value) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (value != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Long remove(int index) {
        this.checkIndex(index);
        long value = this.elements[index];
        int moveCount = this.size - index - 1;
        if (moveCount > 0) {
            System.arraycopy(this.elements, index + 1, this.elements, index, moveCount);
        }
        --this.size;
        return value;
    }

    public boolean removeLong(long value) {
        int index = this.indexOf(value);
        if (-1 != index) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public void forEachOrderedLong(LongConsumer consumer) {
        for (int i = 0; i < this.size; ++i) {
            consumer.accept(this.elements[i]);
        }
    }

    public LongStream longStream() {
        return Arrays.stream(this.elements, 0, this.size);
    }

    public long[] toLongArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    public long[] toLongArray(long[] dst) {
        if (dst.length == this.size) {
            System.arraycopy(this.elements, 0, dst, 0, dst.length);
            return dst;
        }
        return Arrays.copyOf(this.elements, this.size);
    }

    public void ensureCapacity(int requiredCapacity) {
        int capacity = this.elements.length;
        if (requiredCapacity > capacity) {
            int newCapacity = capacity * 2;
            if (newCapacity < 0) {
                if (0x7FFFFFF7 == capacity) {
                    throw new IndexOutOfBoundsException("Max size reached: 2147483639");
                }
                newCapacity = 0x7FFFFFF7;
            }
            long[] newElements = new long[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, capacity);
            this.elements = newElements;
        }
    }

    private void checkIndex(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + " size=" + this.size);
        }
    }

    private void checkIndexForAdd(int index) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + " size=" + this.size);
        }
    }
}

