/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import com.sun.media.sound.MidiOutDeviceProvider;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.spi.MidiDeviceProvider;

public class HighResolutionTimer {
    private static final MidiDevice MIDI_DEVICE;
    private static volatile boolean isEnabled;

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static synchronized void enable() {
        if (null != MIDI_DEVICE && !MIDI_DEVICE.isOpen()) {
            try {
                MIDI_DEVICE.open();
            }
            catch (MidiUnavailableException ignore) {
                isEnabled = false;
                return;
            }
            isEnabled = true;
        }
    }

    public static synchronized void disable() {
        if (MIDI_DEVICE != null && MIDI_DEVICE.isOpen()) {
            MIDI_DEVICE.close();
        }
        isEnabled = false;
    }

    static {
        MidiOutDeviceProvider provider = new MidiOutDeviceProvider();
        MidiDevice.Info[] info = ((MidiDeviceProvider)provider).getDeviceInfo();
        MIDI_DEVICE = info.length > 0 ? ((MidiDeviceProvider)provider).getDevice(info[0]) : null;
        isEnabled = false;
    }
}

