/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.grgit.internal;

import groovy.lang.Closure;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.ajoberstar.grgit.internal.OpSyntax;
import org.ajoberstar.grgit.internal.Operation;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class WithOperationsASTTransformation
extends AbstractASTTransformation {
    public void visit(ASTNode[] nodes, SourceUnit source) {
        AnnotationNode annotation = (AnnotationNode)nodes[0];
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        if (parent instanceof ClassNode) {
            ClassNode clazz = (ClassNode)parent;
            List staticOps = this.getClassList(annotation, "staticOperations");
            List instanceOps = this.getClassList(annotation, "instanceOperations");
            staticOps.forEach(op -> this.makeMethods(clazz, (ClassNode)op, true));
            instanceOps.forEach(op -> this.makeMethods(clazz, (ClassNode)op, false));
        }
    }

    private void makeMethods(ClassNode targetClass, ClassNode opClass, boolean isStatic) {
        AnnotationNode annotation = (AnnotationNode)opClass.getAnnotations(this.classFromType((Type)((Object)Operation.class))).stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Class is not annotated with @Operation: " + opClass));
        String opName = WithOperationsASTTransformation.getMemberStringValue((AnnotationNode)annotation, (String)"value");
        ClassNode opReturn = opClass.getDeclaredMethod("call", new Parameter[0]).getReturnType();
        targetClass.addMethod(this.makeNoArgMethod(targetClass, opName, opClass, opReturn, isStatic));
        targetClass.addMethod(this.makeMapMethod(targetClass, opName, opClass, opReturn, isStatic));
        targetClass.addMethod(this.makeConsumerMethod(targetClass, opName, opClass, opReturn, isStatic));
        targetClass.addMethod(this.makeClosureMethod(targetClass, opName, opClass, opReturn, isStatic));
    }

    private MethodNode makeNoArgMethod(ClassNode targetClass, String opName, ClassNode opClass, ClassNode opReturn, boolean isStatic) {
        Parameter[] parms = new Parameter[]{};
        ExpressionStatement code = new ExpressionStatement((Expression)new StaticMethodCallExpression(this.classFromType((Type)((Object)OpSyntax.class)), "noArgOperation", (Expression)new ArgumentListExpression((Expression)new ClassExpression(opClass), (Expression)new ArrayExpression(this.classFromType((Type)((Object)Object.class)), this.opConstructorParms(targetClass, isStatic)))));
        return new MethodNode(opName, this.modifiers(isStatic), opReturn, parms, new ClassNode[0], (Statement)code);
    }

    private MethodNode makeMapMethod(ClassNode targetClass, String opName, ClassNode opClass, ClassNode opReturn, boolean isStatic) {
        ClassNode parmType = this.classFromType((Type)((Object)Map.class));
        GenericsType[] generics = this.genericsFromTypes(new Type[]{String.class, Object.class});
        parmType.setGenericsTypes(generics);
        Parameter[] parms = new Parameter[]{new Parameter(parmType, "args")};
        ExpressionStatement code = new ExpressionStatement((Expression)new StaticMethodCallExpression(this.classFromType((Type)((Object)OpSyntax.class)), "mapOperation", (Expression)new ArgumentListExpression((Expression)new ClassExpression(opClass), (Expression)new ArrayExpression(this.classFromType((Type)((Object)Object.class)), this.opConstructorParms(targetClass, isStatic)), (Expression)new VariableExpression("args"))));
        return new MethodNode(opName, this.modifiers(isStatic), opReturn, parms, new ClassNode[0], (Statement)code);
    }

    private MethodNode makeConsumerMethod(ClassNode targetClass, String opName, ClassNode opClass, ClassNode opReturn, boolean isStatic) {
        ClassNode parmType = this.classFromType((Type)((Object)Consumer.class));
        GenericsType[] generics = new GenericsType[]{new GenericsType(opClass)};
        parmType.setGenericsTypes(generics);
        Parameter[] parms = new Parameter[]{new Parameter(parmType, "arg")};
        ExpressionStatement code = new ExpressionStatement((Expression)new StaticMethodCallExpression(this.classFromType((Type)((Object)OpSyntax.class)), "consumerOperation", (Expression)new ArgumentListExpression((Expression)new ClassExpression(opClass), (Expression)new ArrayExpression(this.classFromType((Type)((Object)Object.class)), this.opConstructorParms(targetClass, isStatic)), (Expression)new VariableExpression("arg"))));
        return new MethodNode(opName, this.modifiers(isStatic), opReturn, parms, new ClassNode[0], (Statement)code);
    }

    private MethodNode makeClosureMethod(ClassNode targetClass, String opName, ClassNode opClass, ClassNode opReturn, boolean isStatic) {
        ClassNode parmType = this.classFromType((Type)((Object)Closure.class));
        Parameter[] parms = new Parameter[]{new Parameter(parmType, "arg")};
        ExpressionStatement code = new ExpressionStatement((Expression)new StaticMethodCallExpression(this.classFromType((Type)((Object)OpSyntax.class)), "closureOperation", (Expression)new ArgumentListExpression((Expression)new ClassExpression(opClass), (Expression)new ArrayExpression(this.classFromType((Type)((Object)Object.class)), this.opConstructorParms(targetClass, isStatic)), (Expression)new VariableExpression("arg"))));
        return new MethodNode(opName, this.modifiers(isStatic), opReturn, parms, new ClassNode[0], (Statement)code);
    }

    public ClassNode classFromType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isPrimitive()) {
                return ClassHelper.make((Class)clazz);
            }
            return ClassHelper.makeWithoutCaching((Class)clazz, (boolean)false);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            ClassNode base = this.classFromType(ptype.getRawType());
            GenericsType[] generics = this.genericsFromTypes(ptype.getActualTypeArguments());
            base.setGenericsTypes(generics);
            return base;
        }
        throw new IllegalArgumentException("Unsupported type: " + type.getClass());
    }

    public GenericsType[] genericsFromTypes(Type ... types) {
        return (GenericsType[])Arrays.stream(types).map(this::classFromType).map(GenericsType::new).toArray(GenericsType[]::new);
    }

    public List<Expression> opConstructorParms(ClassNode targetClass, boolean isStatic) {
        if (isStatic) {
            return Collections.emptyList();
        }
        FieldNode repo = targetClass.getField("repository");
        return Arrays.asList(new FieldExpression(repo));
    }

    public int modifiers(boolean isStatic) {
        int modifiers = 17;
        if (isStatic) {
            modifiers |= 8;
        }
        return modifiers;
    }
}

