/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.keyvalue;

import alluxio.AlluxioURI;
import alluxio.exception.AlluxioException;
import alluxio.master.keyvalue.KeyValueMaster;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.KeyValueMasterClientService;
import alluxio.thrift.PartitionInfo;
import alluxio.thrift.ThriftIOException;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class KeyValueMasterClientServiceHandler
implements KeyValueMasterClientService.Iface {
    private final KeyValueMaster mKeyValueMaster;

    public KeyValueMasterClientServiceHandler(KeyValueMaster keyValueMaster) {
        this.mKeyValueMaster = keyValueMaster;
    }

    public long getServiceVersion() {
        return 1L;
    }

    public void completePartition(String path, PartitionInfo info) throws AlluxioTException {
        try {
            this.mKeyValueMaster.completePartition(new AlluxioURI(path), info);
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public void createStore(String path) throws AlluxioTException {
        try {
            this.mKeyValueMaster.createStore(new AlluxioURI(path));
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public void completeStore(String path) throws AlluxioTException {
        try {
            this.mKeyValueMaster.completeStore(new AlluxioURI(path));
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public List<PartitionInfo> getPartitionInfo(String path) throws AlluxioTException {
        try {
            return this.mKeyValueMaster.getPartitionInfo(new AlluxioURI(path));
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public void deleteStore(String path) throws AlluxioTException, ThriftIOException {
        try {
            this.mKeyValueMaster.deleteStore(new AlluxioURI(path));
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
        catch (IOException e) {
            throw new ThriftIOException(e.getMessage());
        }
    }

    public void mergeStore(String fromPath, String toPath) throws AlluxioTException, ThriftIOException {
        try {
            this.mKeyValueMaster.mergeStore(new AlluxioURI(fromPath), new AlluxioURI(toPath));
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
        catch (IOException e) {
            throw new ThriftIOException(e.getMessage());
        }
    }
}

